/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.naming;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import jp.go.nict.langrid.commons.util.ArrayUtil;

public class JNDIUtil {
    public static boolean isDataSourceAvailable(String dataSourceName) {
        try {
            DataSource.class.cast(new InitialContext().lookup(dataSourceName));
            return true;
        }
        catch (NamingException e) {
            return false;
        }
    }

    public static void createSubContextAndBind(Context context, String name, Object value) throws NamingException {
        Context current = context;
        String[] subContextNames = name.split("\\/");
        if (subContextNames.length == 1) {
            return;
        }
        for (String n : subContextNames = ArrayUtil.subArray(subContextNames, 0, subContextNames.length - 1)) {
            current = current.createSubcontext(n);
        }
        context.bind(name, value);
    }
}

