/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.util.concurrent;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class SimpleFuture<V>
implements Future<V> {
    private V value;
    private ExecutionException exception;
    private boolean done;
    private boolean cancelled;

    @Override
    public synchronized boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public synchronized boolean isDone() {
        return this.done;
    }

    @Override
    public synchronized boolean cancel(boolean mayInterruptIfRunning) {
        this.cancelled = true;
        return true;
    }

    @Override
    public synchronized V get() throws InterruptedException, ExecutionException {
        if (this.done) {
            if (this.exception != null) {
                throw this.exception;
            }
            return this.value;
        }
        if (this.cancelled) {
            throw new InterruptedException("operation cancelled.");
        }
        this.wait();
        if (this.exception != null) {
            throw this.exception;
        }
        return this.value;
    }

    @Override
    public synchronized V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.done) {
            if (this.exception != null) {
                throw this.exception;
            }
            return this.value;
        }
        if (this.cancelled) {
            throw new InterruptedException("operation cancelled.");
        }
        this.wait(unit.toMillis(timeout));
        if (this.exception != null) {
            throw this.exception;
        }
        if (this.value == null) {
            throw new TimeoutException();
        }
        return this.value;
    }

    public synchronized void set(V value) throws IllegalStateException {
        if (this.done) {
            throw new IllegalStateException("The result or exception is already set.");
        }
        this.value = value;
        this.done = true;
        this.notifyAll();
    }

    public synchronized void setException(ExecutionException exception) throws IllegalStateException {
        if (this.done) {
            throw new IllegalStateException("The result or exception is already set.");
        }
        this.exception = exception;
        this.done = true;
        this.notifyAll();
    }
}

