/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DuplicatingInputStream
extends FilterInputStream {
    private OutputStream outputStream;

    public DuplicatingInputStream(InputStream source, OutputStream outputStream) {
        super(source);
        this.outputStream = outputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.outputStream.close();
    }

    @Override
    public int read() throws IOException {
        int r = this.in.read();
        if (r != -1) {
            this.outputStream.write(r);
        }
        return r;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int size = this.in.read(b);
        if (size != -1) {
            this.outputStream.write(b, 0, size);
        }
        return size;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int size = this.in.read(b, off, len);
        if (size != -1) {
            this.outputStream.write(b, off, size);
        }
        return size;
    }
}

