/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.parameter;

import java.lang.reflect.Field;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.go.nict.langrid.commons.parameter.ParameterContext;
import jp.go.nict.langrid.commons.parameter.ParameterRequiredException;
import jp.go.nict.langrid.commons.parameter.annotation.Parameter;
import jp.go.nict.langrid.commons.parameter.annotation.ParameterConfig;
import jp.go.nict.langrid.commons.transformer.StringToURITransformer;
import jp.go.nict.langrid.commons.transformer.StringToURLTransformer;
import jp.go.nict.langrid.commons.transformer.StringTransformerRepository;
import jp.go.nict.langrid.commons.transformer.TransformationException;
import jp.go.nict.langrid.commons.transformer.Transformer;

public class ParameterLoader {
    private StringTransformerRepository transformers = new StringTransformerRepository();
    private static Logger logger = Logger.getLogger(ParameterLoader.class.getName());

    public ParameterLoader() {
        this.transformers.add(URL.class, new StringToURLTransformer());
        this.transformers.add(URI.class, new StringToURITransformer());
    }

    public <T> void registerTransformer(Class<T> targetClass, Transformer<String, T> transformer) {
        this.transformers.add(targetClass, transformer);
    }

    public void load(Object bean, ParameterContext context) throws ParameterRequiredException {
        this.load(bean, context, new LinkedList<String>());
    }

    public void load(Object bean, ParameterContext context, boolean loadAllFields) throws ParameterRequiredException {
        this.load(bean, context, new LinkedList<String>(), loadAllFields);
    }

    public void load(Object bean, ParameterContext context, Collection<String> noNamedParams) throws ParameterRequiredException {
        this.load(bean, context, noNamedParams, false);
    }

    public void load(Object bean, ParameterContext context, Collection<String> noNamedParams, boolean loadAllFields) throws ParameterRequiredException {
        LinkedList<String> params = new LinkedList<String>();
        params.addAll(noNamedParams);
        Class clazz = bean.getClass();
        if (bean instanceof Class) {
            clazz = (Class)bean;
            bean = null;
        }
        String prefix = "";
        boolean loadAll = loadAllFields;
        ParameterConfig pc = clazz.getAnnotation(ParameterConfig.class);
        if (pc != null) {
            prefix = pc.prefix();
            loadAll = pc.loadAllFields();
        }
        for (Field f : clazz.getDeclaredFields()) {
            if (f.isSynthetic()) continue;
            String parameterName = "";
            boolean required = false;
            String defaultValue = "";
            Parameter p = f.getAnnotation(Parameter.class);
            if (p != null) {
                parameterName = p.name();
                required = p.required();
                defaultValue = p.defaultValue();
            } else if (!loadAll) continue;
            String name = prefix + (parameterName.length() > 0 ? parameterName : f.getName());
            Object value = null;
            Class<?> type = f.getType();
            Transformer<String, ?> transformer = this.findTransformer(type);
            if (transformer == null) {
                logger.severe("no suitable transformer found for parameter \"" + name + "\"(type: \"" + type + "\")");
            }
            if ((value = ParameterLoader.getTransformedValue(transformer, type, name, context.getValue(name))) == null) {
                value = ParameterLoader.getTransformedValue(transformer, type, name, (String)params.poll());
            }
            if (value == null && defaultValue.length() > 0) {
                value = ParameterLoader.getTransformedValue(transformer, type, name, defaultValue);
            }
            boolean valueSet = false;
            if (value != null) {
                try {
                    if (!f.isAccessible()) {
                        f.setAccessible(true);
                    }
                    f.set(bean, value);
                    valueSet = true;
                }
                catch (IllegalArgumentException e) {
                    logger.log(Level.SEVERE, "failed to convert value. parameter:\"" + name + "\" value:\"" + value + "\".", e);
                }
                catch (IllegalAccessException e) {
                    logger.log(Level.SEVERE, "failed to access parameter field. parameter:\"" + name + "\" value:\"" + value + "\".", e);
                }
                catch (SecurityException e) {
                    logger.log(Level.SEVERE, "failed to store parameter value. parameter:\"" + name + "\" value:\"" + value + "\".", e);
                }
            }
            if (valueSet || !required) continue;
            throw new ParameterRequiredException(name);
        }
    }

    private static Object getTransformedValue(Transformer<String, ?> transformer, Class<?> type, String name, String value) {
        if (value == null) {
            return null;
        }
        if (transformer == null) {
            return null;
        }
        try {
            return transformer.transform(value);
        }
        catch (TransformationException e) {
            logger.warning("failed to convert value \"" + value + "\" to type \"" + type + "\" for parameter \"" + name + "\"");
            return null;
        }
    }

    private Transformer<String, ?> findTransformer(Class<?> clazz) {
        return this.transformers.find(clazz);
    }
}

