/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;

public class CalendarUtil {
    public static final Calendar MAX_VALUE_IN_EPOC;
    public static final Calendar MIN_VALUE_IN_EPOC;
    private static final String FORMAT_HTTPDATE = "%ta, %1$td %1$tb %1$tY %1$tT %1$tZ";
    private static final String FORMAT_W3CDTF_Y = "yyyy";
    private static final String FORMAT_W3CDTF_YM = "yyyy-MM";
    private static final String FORMAT_W3CDTF_YMD = "yyyy-MM-dd";
    private static final String FORMAT_W3CDTF_WO_TZ = "yyyy-MM-dd'T'HH:mm:ss.S";
    private static final String FORMAT_SIMPLEDATE = "yyyy-MM-dd HH:mm:ss.SSS z";
    private static ThreadLocal<DateFormat> codeFormat;
    private static ThreadLocal<DateFormat> w3ctzFormatY;
    private static ThreadLocal<DateFormat> w3ctzFormatYM;
    private static ThreadLocal<DateFormat> w3ctzFormatYMD;
    private static ThreadLocal<DateFormat> w3ctzFormat;

    public static Calendar createFromMillis(long milliseconds) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(milliseconds);
        return c;
    }

    public static Calendar create(int year, int month, int date) {
        Calendar c = Calendar.getInstance();
        c.set(year, month - 1, date, 0, 0, 0);
        c.set(14, 0);
        return c;
    }

    public static Calendar create(int year, int month, int date, TimeZone timeZone) {
        Calendar c = Calendar.getInstance(timeZone);
        c.set(year, month - 1, date, 0, 0, 0);
        c.set(14, 0);
        return c;
    }

    public static Calendar create(int year, int month, int date, int hourOfDay, int minute, int second) {
        Calendar c = Calendar.getInstance();
        c.set(year, month - 1, date, hourOfDay, minute, second);
        c.set(14, 0);
        return c;
    }

    public static Calendar create(int year, int month, int date, int hourOfDay, int minute, int second, int milliseconds) {
        Calendar c = Calendar.getInstance();
        c.set(year, month - 1, date, hourOfDay, minute, second);
        c.set(14, milliseconds);
        return c;
    }

    public static Calendar createBeginningOfYear(Calendar calendar) {
        Calendar c = (Calendar)calendar.clone();
        c.set(c.get(1), 0, 1, 0, 0, 0);
        c.set(14, 0);
        return c;
    }

    public static Calendar createBeginningOfMonth(Calendar calendar) {
        Calendar c = (Calendar)calendar.clone();
        c.set(c.get(1), c.get(2), 1, 0, 0, 0);
        c.set(14, 0);
        return c;
    }

    public static Calendar createBeginningOfDay(Calendar calendar) {
        Calendar c = (Calendar)calendar.clone();
        c.set(c.get(1), c.get(2), c.get(5), 0, 0, 0);
        c.set(14, 0);
        return c;
    }

    public static Calendar createEndingOfDay(Calendar calendar) {
        Calendar c = (Calendar)calendar.clone();
        c.set(c.get(1), c.get(2), c.get(5), 23, 59, 59);
        c.set(14, 999);
        return c;
    }

    public static Calendar cloneAndAdd(Calendar source, int field, int amount) {
        Calendar r = (Calendar)source.clone();
        r.add(field, amount);
        return r;
    }

    public static String formatToHTTPDate(Calendar calendar) {
        return String.format(Locale.ENGLISH, FORMAT_HTTPDATE, calendar);
    }

    public static String formatToW3CDTF(Calendar calendar) {
        String tz = "Z";
        int value = (calendar.get(15) + calendar.get(16)) / 60000;
        if (value != 0) {
            char sign = '+';
            if (value < 0) {
                value = -value;
                sign = '-';
            }
            tz = String.format("%c%02d:%02d", Character.valueOf(sign), value / 60, value % 60);
        }
        DateFormat df = w3ctzFormat.get();
        df.setTimeZone(calendar.getTimeZone());
        return df.format(calendar.getTime()) + tz;
    }

    public static String formatToDefault(Calendar calendar) {
        return DateFormat.getDateTimeInstance().format(calendar.getTime());
    }

    public static String formatNowToHTTPDate() {
        return CalendarUtil.formatToHTTPDate(Calendar.getInstance(TimeZone.getTimeZone("GMT")));
    }

    public static String formatNowToW3CTDF() {
        return CalendarUtil.formatToW3CDTF(Calendar.getInstance());
    }

    public static String encodeToSimpleDate(Calendar value) {
        return codeFormat.get().format(value.getTime());
    }

    public static Calendar decodeFromSimpleDate(String line) throws ParseException {
        Calendar c = Calendar.getInstance();
        c.setTime(codeFormat.get().parse(line));
        return c;
    }

    public static Calendar decodeFromW3CDTF(String line) throws ParseException {
        Calendar c = Calendar.getInstance();
        try {
            c.setTime(w3ctzFormat.get().parse(line));
            return c;
        }
        catch (ParseException parseException) {
            try {
                c.setTime(w3ctzFormatYMD.get().parse(line));
                return c;
            }
            catch (ParseException parseException2) {
                try {
                    c.setTime(w3ctzFormatYM.get().parse(line));
                    return c;
                }
                catch (ParseException parseException3) {
                    c.setTime(w3ctzFormatY.get().parse(line));
                    return c;
                }
            }
        }
    }

    public static Calendar toDefaultTimeZone(Calendar calendar) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(calendar.getTimeInMillis());
        return c;
    }

    static {
        codeFormat = new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return new SimpleDateFormat(CalendarUtil.FORMAT_SIMPLEDATE);
            }
        };
        w3ctzFormatY = new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return new SimpleDateFormat(CalendarUtil.FORMAT_W3CDTF_Y);
            }
        };
        w3ctzFormatYM = new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return new SimpleDateFormat(CalendarUtil.FORMAT_W3CDTF_YM);
            }
        };
        w3ctzFormatYMD = new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return new SimpleDateFormat(CalendarUtil.FORMAT_W3CDTF_YMD);
            }
        };
        w3ctzFormat = new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return new SimpleDateFormat(CalendarUtil.FORMAT_W3CDTF_WO_TZ);
            }
        };
        MAX_VALUE_IN_EPOC = Calendar.getInstance();
        MAX_VALUE_IN_EPOC.set(9999, 11, 31, 23, 59, 59);
        MAX_VALUE_IN_EPOC.set(14, 999);
        MIN_VALUE_IN_EPOC = Calendar.getInstance();
        MIN_VALUE_IN_EPOC.setTimeInMillis(0L);
    }
}

