/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.ws.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import jp.go.nict.langrid.commons.lang.StringUtil;

public class MimeHeadersUtil {
    public static boolean isTrue(MimeHeaders headers, String name) {
        String[] values = headers.getHeader(name);
        if (values == null) {
            return false;
        }
        if (values.length == 0) {
            return false;
        }
        for (String v : values) {
            if (v.equals("true")) continue;
            return false;
        }
        return true;
    }

    public static String getJoinedValue(MimeHeaders headers, String name) {
        String[] values = headers.getHeader(name);
        if (values == null) {
            return null;
        }
        if (values.length == 0) {
            return "";
        }
        return StringUtil.join(values, ",");
    }

    public static String getJoinedAndDecodedValue(MimeHeaders headers, String name) {
        String[] values = headers.getHeader(name);
        if (values == null) {
            return null;
        }
        try {
            return URLDecoder.decode(StringUtil.join(values, ","), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getJoinedAndDecodedValue(MimeHeaders headers, String name, String separator) {
        String[] values = headers.getHeader(name);
        if (values == null) {
            return null;
        }
        try {
            return URLDecoder.decode(StringUtil.join(values, separator), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setToHttpServletResponse(MimeHeaders headers, HttpServletResponse response) {
        Iterator i = headers.getAllHeaders();
        while (i.hasNext()) {
            MimeHeader h = (MimeHeader)i.next();
            response.addHeader(h.getName(), h.getValue());
        }
    }

    public static MimeHeaders fromStringObjectMap(Map<String, Object> source) {
        MimeHeaders ret = new MimeHeaders();
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof String) {
                ret.addHeader(name, value.toString());
                continue;
            }
            if (value instanceof String[]) {
                for (String v : (String[])value) {
                    ret.addHeader(name, v);
                }
                continue;
            }
            if (value instanceof Iterable) {
                for (Object v : (Iterable)value) {
                    ret.addHeader(name, v.toString());
                }
                continue;
            }
            ret.addHeader(name, value.toString());
        }
        return ret;
    }
}

