/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.codec;

import jp.go.nict.langrid.commons.codec.FileNameCodec;

public class UnixFileNameCodec
extends FileNameCodec {
    @Override
    public String encode(String value) {
        StringBuilder b = new StringBuilder();
        if (value.equals(".")) {
            return this.backslashEncode('.');
        }
        if (value.equals("..")) {
            return this.backslashEncode('.') + this.backslashEncode('.');
        }
        char[] chars = value.toCharArray();
        block3: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            switch (c) {
                case '/': {
                    b.append(this.backslashEncode(c));
                    continue block3;
                }
                default: {
                    b.append(c);
                }
            }
        }
        return b.toString();
    }

    @Override
    public String decode(String value) {
        return this.decode(value, '\\');
    }

    protected String backslashEncode(char c) {
        return String.format("\\%02x", c);
    }
}

