/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.cs.calltree;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jp.go.nict.langrid.commons.codec.URLCodec;
import jp.go.nict.langrid.commons.cs.calltree.CallNode;
import jp.go.nict.langrid.commons.rpc.RpcHeader;
import jp.go.nict.langrid.commons.ws.MimeHeaders;
import jp.go.nict.langrid.repackaged.net.arnx.jsonic.JSON;
import jp.go.nict.langrid.repackaged.net.arnx.jsonic.JSONException;

public class CallTreeUtil {
    public static String encodeTree(Collection<CallNode> value) {
        return JSON.encode(value);
    }

    public static String encodeTree(Collection<CallNode> value, int indentFactor) {
        return JSON.encode(value, true);
    }

    public static Collection<CallNode> decodeTree(String value) throws ParseException {
        try {
            return (Collection)JSON.decode(value, new ArrayList<CallNode>(){}.getClass().getGenericSuperclass());
        }
        catch (JSONException e) {
            throw new ParseException(e.getMessage(), -1);
        }
    }

    public static Collection<CallNode> decodeTreeFromHttpBody(String body) throws ParseException {
        int i = body.indexOf("calltree");
        int begin = body.indexOf(">", i) + 1;
        int end = body.indexOf("<", begin);
        String callTreeJson = body.substring(begin, end);
        callTreeJson = URLCodec.decode(callTreeJson);
        callTreeJson = callTreeJson.replace("&quot;", "\"");
        return CallTreeUtil.decodeTree(callTreeJson);
    }

    public static CallNode createNode(MimeHeaders mimeHeaders, Iterable<RpcHeader> rpcHeaders) throws ParseException {
        CallNode node = new CallNode();
        node.setServiceName(mimeHeaders.getJoinedHeader("X-LanguageGrid-ServiceName"));
        node.setServiceCopyright(mimeHeaders.getJoinedHeader("X-LanguageGrid-ServiceCopyright"));
        node.setServiceLicense(mimeHeaders.getJoinedHeader("X-LanguageGrid-ServiceLicense"));
        if (rpcHeaders != null) {
            for (RpcHeader h : rpcHeaders) {
                if (!h.getNamespace().equals("http://langrid.nict.go.jp/process/calltree")) continue;
                Collection<CallNode> cn = CallTreeUtil.decodeTree(h.getValue());
                node.getChildren().addAll(cn);
            }
        }
        return node;
    }

    public static List<CallNode> extractNodes(Iterable<RpcHeader> headers) throws ParseException {
        ArrayList<CallNode> nodes = new ArrayList<CallNode>();
        for (RpcHeader h : headers) {
            if (!h.getNamespace().equals("http://langrid.nict.go.jp/process/calltree")) continue;
            Collection<CallNode> cn = CallTreeUtil.decodeTree(h.getValue());
            nodes.addAll(cn);
        }
        return nodes;
    }
}

