/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.lang;

public class CharSequenceUtil {
    public static CharSequence empty() {
        return new CharSequence(){

            @Override
            public CharSequence subSequence(int start, int end) {
                CharSequenceUtil.checkIndex(start, end, this.length());
                return CharSequenceUtil.empty();
            }

            @Override
            public int length() {
                return 0;
            }

            @Override
            public char charAt(int index) {
                throw new IndexOutOfBoundsException();
            }

            @Override
            public String toString() {
                return "" + this;
            }
        };
    }

    public static CharSequence repeat(final char c, final int count) {
        return new CharSequence(){

            @Override
            public CharSequence subSequence(int start, int end) {
                CharSequenceUtil.checkIndex(start, end, this.length());
                return CharSequenceUtil.repeat(c, end - start);
            }

            @Override
            public int length() {
                return count;
            }

            @Override
            public char charAt(int arg0) {
                return c;
            }

            @Override
            public String toString() {
                return "" + this;
            }
        };
    }

    private static void checkIndex(int start, int end, int length) {
        if (start < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (end < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (end > length) {
            throw new IndexOutOfBoundsException();
        }
        if (start > end) {
            throw new IndexOutOfBoundsException();
        }
    }
}

