/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.transformer;

import java.lang.reflect.Type;
import jp.go.nict.langrid.commons.lang.reflect.GenericsUtil;
import jp.go.nict.langrid.commons.transformer.TransformationException;
import jp.go.nict.langrid.commons.transformer.Transformer;
import jp.go.nict.langrid.commons.util.ArrayUtil;

public class ArrayToArrayTransformer<T, U>
implements Transformer<T[], U[]> {
    private Class<U> targetClass;
    private Transformer<T, U> elementTransformer;

    public ArrayToArrayTransformer(Class<U> targetClass, Transformer<T, U> elementTransformer) throws IllegalArgumentException {
        this.targetClass = targetClass;
        this.elementTransformer = elementTransformer;
    }

    public ArrayToArrayTransformer(Transformer<T, U> elementTransformer) throws IllegalArgumentException {
        this.elementTransformer = elementTransformer;
        Type[] types = GenericsUtil.getActualTypeArgumentTypes(elementTransformer.getClass(), Transformer.class);
        this.targetClass = (Class)types[1];
        if (this.targetClass == null) {
            throw new IllegalArgumentException("failed to extract target class info from elementTransformer");
        }
    }

    @Override
    public U[] transform(T[] value) throws TransformationException {
        if (value == null) {
            return null;
        }
        return ArrayUtil.collect(value, this.targetClass, this.elementTransformer);
    }
}

