/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.ws;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.go.nict.langrid.commons.rpc.RpcHeader;
import jp.go.nict.langrid.commons.ws.FilePersistentProperties;
import jp.go.nict.langrid.commons.ws.MimeHeaders;
import jp.go.nict.langrid.commons.ws.ServiceContext;

public class LocalServiceContext
extends ServiceContext {
    private MimeHeaders requestMimeHeaders = new MimeHeaders();
    private List<RpcHeader> requestRpcHeaders = new ArrayList<RpcHeader>();
    private String gridId = "grid1";
    private String userId = "user1";
    private String password = "pass";
    private String remoteAddress = "127.0.0.1";
    private String requestRootUrl = "http://localhost/";
    private String realPathBase = ".";
    private Map<String, Object> sessionProps = new HashMap<String, Object>();
    private FilePersistentProperties props = new FilePersistentProperties(new File("local.properties"));

    public LocalServiceContext() {
    }

    public LocalServiceContext(String authUserId) {
        this.userId = authUserId;
    }

    @Override
    public URL getRequestUrl() {
        try {
            return new URL(this.requestRootUrl + "langrid-1.2/");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public MimeHeaders getRequestMimeHeaders() {
        return this.requestMimeHeaders;
    }

    public void setRequestMimeHeaders(MimeHeaders value) {
        this.requestMimeHeaders = value;
    }

    @Override
    public Iterable<RpcHeader> getRequestRpcHeaders() {
        return this.requestRpcHeaders;
    }

    public void setRequestRpcHeaders(Iterable<RpcHeader> value) {
        this.requestRpcHeaders = new ArrayList<RpcHeader>();
        for (RpcHeader h : value) {
            this.requestRpcHeaders.add(h);
        }
    }

    public void setRequestRootUrl(String url) {
        this.requestRootUrl = url;
    }

    @Override
    public String getAuthUserGridId() {
        return this.gridId;
    }

    @Override
    public String getAuthUser() {
        return this.userId;
    }

    public void setAuthUser(String userId, String password) {
        this.userId = userId;
        this.password = password;
    }

    public void setAuthUser(String gridId, String userId, String password) {
        this.gridId = gridId;
        this.userId = userId;
        this.password = password;
    }

    @Override
    public String getAuthPass() {
        return this.password;
    }

    @Override
    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public void setRemoteAddress(String value) {
        this.remoteAddress = value;
    }

    @Override
    public String getInitParameter(String param) {
        return System.getProperty(param);
    }

    @Override
    public <T> T getSessionProperty(String name) {
        return (T)this.sessionProps.get(name);
    }

    @Override
    public void setSessionProperty(String name, Object value) {
        this.sessionProps.put(name, value);
    }

    @Override
    public void removeSessionProperty(String name) {
        this.sessionProps.remove(name);
    }

    @Override
    public String getPersistentProperty(String name) {
        return this.props.getProperty(name);
    }

    @Override
    public void setPersistentProperty(String name, String value) {
        this.props.setProperty(name, value);
    }

    @Override
    public String getRealPath(String path) {
        return this.realPathBase + path;
    }

    public void setRealPathBase(String base) {
        this.realPathBase = base;
    }
}

