/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.ws;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import jp.go.nict.langrid.commons.lang.StringUtil;
import jp.go.nict.langrid.commons.util.Pair;

public class MimeHeaders {
    private Map<String, Pair<String, List<String>>> headers = new TreeMap<String, Pair<String, List<String>>>();

    public String[] getHeader(String name) {
        Pair<String, List<String>> h = this.headers.get(name.toLowerCase());
        if (h != null) {
            return h.getSecond().toArray(new String[0]);
        }
        return null;
    }

    public String getJoinedHeader(String name, String separator) {
        List<String> values = this.headers.get(name.toLowerCase()).getSecond();
        if (values == null) {
            return null;
        }
        return StringUtil.join(values.toArray(new String[0]), ",");
    }

    public String getJoinedHeader(String name) {
        return this.getJoinedHeader(name, ",");
    }

    public void setHeader(String name, String value) {
        List values = (List)this.headers.computeIfAbsent(name.toLowerCase(), n -> Pair.create(name, new ArrayList())).getSecond();
        values.clear();
        values.add(value);
    }

    public void addHeader(String name, String value) {
        if (name == null) {
            return;
        }
        ((List)this.headers.computeIfAbsent(name.toLowerCase(), n -> Pair.create(name, new ArrayList())).getSecond()).add(value);
    }

    public void removeHeader(String name) {
        this.headers.remove(name.toLowerCase());
    }

    public void removeAllHeaders() {
        this.headers.clear();
    }

    public Iterator<Pair<String, String>> getAllHeaders() {
        ArrayList<Pair<String, String>> ret = new ArrayList<Pair<String, String>>();
        for (Pair<String, List<String>> h : this.headers.values()) {
            for (String v : h.getSecond()) {
                ret.add(Pair.create(h.getFirst(), v));
            }
        }
        return ret.iterator();
    }
}

