/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.beanutils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import jp.go.nict.langrid.commons.beanutils.Converter;
import jp.go.nict.langrid.commons.transformer.TransformationException;
import jp.go.nict.langrid.commons.transformer.Transformer;
import jp.go.nict.langrid.commons.util.ListUtil;

public class StringArrayToBeanTransformer<T>
implements Transformer<String[], T> {
    private Class<T> clazz;
    private Converter converter;
    private String[] properties;

    public StringArrayToBeanTransformer(Class<T> clazz, Converter converter, String[] properties) {
        this.clazz = clazz;
        this.converter = converter;
        this.properties = properties;
    }

    @Override
    public T transform(String[] value) throws TransformationException {
        try {
            T o = this.clazz.newInstance();
            int n = Math.min(value.length, this.properties.length);
            for (int i = 0; i < n; ++i) {
                Method[] methods = this.getSetters(this.clazz, this.properties[i]);
                if (methods.length == 0) continue;
                try {
                    methods[0].invoke(o, this.converter.convert((Object)value[i], methods[0].getParameterTypes()[0]));
                    continue;
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            return o;
        }
        catch (IllegalAccessException e) {
            throw new TransformationException(e);
        }
        catch (InstantiationException e) {
            throw new TransformationException(e);
        }
    }

    private Method[] getSetters(Class<T> clazz, String propertyName) {
        String methodName = "set" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        List<Method> methods = ListUtil.newArrayList();
        for (Method m : clazz.getMethods()) {
            if (!m.getName().equals(methodName) || m.getParameterTypes().length != 1) continue;
            methods.add(m);
        }
        return methods.toArray(new Method[0]);
    }
}

