/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.transformer;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import jp.go.nict.langrid.commons.transformer.TransformationException;
import jp.go.nict.langrid.commons.transformer.Transformer;

public class BeanToPropertyTransformer<T, U>
implements Transformer<T, U> {
    private Method getter;

    public BeanToPropertyTransformer(Class<T> beanClass, String propName, Class<U> propClass) throws NoSuchMethodException {
        this.getter = beanClass.getMethod("get" + propName.substring(0, 1).toUpperCase() + propName.substring(1), new Class[0]);
        if (!propClass.isAssignableFrom(this.getter.getReturnType())) {
            throw new ClassCastException("cannot cast " + this.getter.getReturnType() + " to " + propClass);
        }
    }

    @Override
    public U transform(T value) throws TransformationException {
        try {
            return (U)this.getter.invoke(value, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new TransformationException(e);
        }
        catch (InvocationTargetException e) {
            throw new TransformationException(e);
        }
    }
}

