/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.ws;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FilePersistentProperties {
    private File propertyFile;
    private static Map<File, Properties> properties = new ConcurrentHashMap<File, Properties>();
    private static Logger logger = Logger.getLogger(FilePersistentProperties.class.getName());

    public FilePersistentProperties(File propertyFile) {
        this.propertyFile = propertyFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProperty(String name) {
        Map<File, Properties> map = properties;
        synchronized (map) {
            try {
                return this.prepareProperties().getProperty(name);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "can't load properties", e);
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(String name, String value) {
        Map<File, Properties> map = properties;
        synchronized (map) {
            Properties props = new Properties();
            try {
                props = FilePersistentProperties.loadProperties(this.propertyFile);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "can't load properties", e);
                return;
            }
            props.setProperty(name, value);
            try {
                FilePersistentProperties.storeProperties(props, this.propertyFile);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "can't store properties", e);
                return;
            }
        }
    }

    private Properties prepareProperties() throws IOException {
        Properties props = properties.get(this.propertyFile);
        if (props != null) {
            return props;
        }
        props = FilePersistentProperties.loadProperties(this.propertyFile);
        properties.put(this.propertyFile, props);
        return props;
    }

    private static Properties loadProperties(File file) throws FileNotFoundException, IOException {
        Properties props = new Properties();
        if (file.exists()) {
            FileInputStream is = new FileInputStream(file);
            props.load(is);
            ((InputStream)is).close();
        } else {
            file.createNewFile();
        }
        return props;
    }

    private static void storeProperties(Properties props, File file) throws FileNotFoundException, IOException {
        FileOutputStream os = new FileOutputStream(file);
        props.store(os, "persitent properties");
        ((OutputStream)os).close();
        properties.put(file, props);
    }
}

