/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.ws;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import jp.go.nict.langrid.commons.util.Trio;

public class HttpServletRequestUtil {
    private static Pattern urlParsePat = Pattern.compile("\\w+:\\/\\/[\\w\\.\\:\\-_]+\\/[\\w\\.\\-]+\\/[\\w\\.\\-_]+\\/([\\w\\.\\-_]*)(:([\\w\\.\\-]+))?(.*)");

    public static URL getRequestUrl(HttpServletRequest request) {
        try {
            String query = request.getQueryString();
            query = query != null ? "?" + query : "";
            return new URL(request.getRequestURL().append(query).toString());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static Trio<String, String, String> parseRequestUrl(HttpServletRequest request) {
        String url = request.getRequestURL().toString();
        String query = request.getQueryString();
        Matcher m = urlParsePat.matcher(url);
        if (!m.matches()) {
            return null;
        }
        if (m.groupCount() != 4) {
            return null;
        }
        String gid = null;
        String sid = null;
        String additional = null;
        if (m.group(3) != null) {
            gid = m.group(1);
            sid = m.group(3);
        } else {
            sid = m.group(1);
        }
        if (m.group(4) != null && m.group(4).length() > 0) {
            additional = query != null ? m.group(4) + "?" + query : m.group(4);
        } else if (query != null) {
            additional = "?" + query;
        }
        return Trio.create(gid, sid, additional);
    }

    public static String getQueryValue(String query, String name) {
        for (String nv : query.split("^\\?|\\&")) {
            String[] v;
            if (nv.length() == 0 || !(v = nv.split("=", 2))[0].equals(name)) continue;
            if (v.length == 1) {
                return "";
            }
            return v[1];
        }
        return null;
    }

    public static Map<String, List<String>> queryToMap(String query) {
        LinkedHashMap<String, List<String>> ret = new LinkedHashMap<String, List<String>>();
        if (query == null) {
            return ret;
        }
        for (String nv : query.split("^\\?|\\&")) {
            String value;
            String[] v;
            String name;
            if (nv.length() == 0 || (name = (v = nv.split("=", 2))[0].trim()).length() == 0) continue;
            ArrayList<String> values = (ArrayList<String>)ret.get(name);
            if (values == null) {
                values = new ArrayList<String>();
                ret.put(name, values);
            }
            if (v.length <= 1 || (value = v[1].trim()).length() <= 0) continue;
            values.add(value);
        }
        return ret;
    }

    public static String mapToQuery(Map<String, List<String>> map) {
        StringBuilder b = new StringBuilder();
        b.append("?");
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            String name = entry.getKey();
            List<String> values = entry.getValue();
            if (values.size() == 0) {
                if (b.length() > 1) {
                    b.append("&");
                }
                b.append(name);
                continue;
            }
            for (String v : values) {
                if (b.length() > 1) {
                    b.append("&");
                }
                b.append(name).append("=").append(v);
            }
        }
        if (b.length() == 1) {
            return "";
        }
        return b.toString();
    }
}

