/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.ws.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import jp.go.nict.langrid.commons.lang.StringUtil;
import jp.go.nict.langrid.commons.util.Pair;
import jp.go.nict.langrid.commons.ws.MimeHeaders;

public class MimeHeadersUtil {
    public static boolean isTrue(MimeHeaders headers, String name) {
        String[] values = headers.getHeader(name);
        if (values == null) {
            return false;
        }
        if (values.length == 0) {
            return false;
        }
        for (String v : values) {
            if (v.equals("true")) continue;
            return false;
        }
        return true;
    }

    public static String getJoinedValue(MimeHeaders headers, String name) {
        String[] values = headers.getHeader(name);
        if (values == null) {
            return null;
        }
        if (values.length == 0) {
            return "";
        }
        return StringUtil.join(values, ",");
    }

    public static String getJoinedAndDecodedValue(MimeHeaders headers, String name) {
        String[] values = headers.getHeader(name);
        if (values == null) {
            return null;
        }
        try {
            return URLDecoder.decode(StringUtil.join(values, ","), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getJoinedAndDecodedValue(MimeHeaders headers, String name, String separator) {
        String[] values = headers.getHeader(name);
        if (values == null) {
            return null;
        }
        try {
            return URLDecoder.decode(StringUtil.join(values, separator), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setToHttpServletResponse(MimeHeaders headers, HttpServletResponse response) {
        Iterator<Pair<String, String>> i = headers.getAllHeaders();
        while (i.hasNext()) {
            Pair<String, String> h = i.next();
            response.addHeader(h.getFirst(), h.getSecond());
        }
    }

    public static void setToHttpServletResponse(Map<String, String> headers, HttpServletResponse response) {
        for (Map.Entry<String, String> e : headers.entrySet()) {
            response.addHeader(e.getKey(), e.getValue());
        }
    }

    public static MimeHeaders fromStringObjectMap(Map<String, Object> source) {
        MimeHeaders ret = new MimeHeaders();
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof String) {
                ret.addHeader(name, value.toString());
                continue;
            }
            if (value instanceof String[]) {
                for (String v : (String[])value) {
                    ret.addHeader(name, v);
                }
                continue;
            }
            if (value instanceof Iterable) {
                for (Object v : (Iterable)value) {
                    ret.addHeader(name, v.toString());
                }
                continue;
            }
            ret.addHeader(name, value.toString());
        }
        return ret;
    }
}

