/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.repackaged.net.arnx.jsonic;

import jp.go.nict.langrid.repackaged.net.arnx.jsonic.OutputSource;

final class CharSequenceOutputSource
implements OutputSource {
    int lines = 1;
    int columns = 1;
    int offset = 0;
    final CharSequence cs;

    public CharSequenceOutputSource(CharSequence cs) {
        if (cs == null) {
            throw new NullPointerException();
        }
        this.cs = cs;
    }

    @Override
    public int next() {
        if (this.offset < this.cs.length()) {
            char c;
            if ((c = this.cs.charAt(this.offset++)) == '\r' || c == '\n' && this.offset > 1 && this.cs.charAt(this.offset - 2) != '\r') {
                ++this.lines;
                this.columns = 0;
            } else {
                ++this.columns;
            }
            return c;
        }
        return -1;
    }

    @Override
    public void back() {
        --this.offset;
        --this.columns;
    }

    @Override
    public long getLineNumber() {
        return this.lines;
    }

    @Override
    public long getColumnNumber() {
        return this.columns;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    public String toString() {
        return this.cs.subSequence(this.offset - this.columns + 1, this.offset).toString();
    }
}

