/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.composite.commons.test;

import java.io.IOException;
import java.net.URL;
import jp.go.nict.langrid.client.ClientFactory;
import jp.go.nict.langrid.client.jsonrpc.JsonRpcClientFactory;
import jp.go.nict.langrid.client.ws_1_2.SimilarityCalculationClient;
import jp.go.nict.langrid.client.ws_1_2.error.LangridException;
import jp.go.nict.langrid.composite.commons.test.TestContext;
import jp.go.nict.langrid.language.InvalidLanguageTagException;
import jp.go.nict.langrid.language.Language;
import jp.go.nict.langrid.service_1_2.ProcessFailedException;
import jp.go.nict.langrid.service_1_2.similaritycalculation.SimilarityCalculationService;

public class SimilarityCalculationClientAdapter
implements SimilarityCalculationService {
    private SimilarityCalculationClient client;

    public SimilarityCalculationClientAdapter(String serviceId) {
        try {
            TestContext tc = new TestContext(this.getClass(), (ClientFactory)new JsonRpcClientFactory());
            this.client = jp.go.nict.langrid.client.ws_1_2.ClientFactory.createSimilarityCalculationClient((URL)new URL(tc.getBaseUrl() + serviceId));
            this.client.setUserId(tc.getUserId());
            this.client.setPassword(tc.getPassword());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public double calculate(String language, String text1, String text2) throws ProcessFailedException {
        try {
            return this.client.calculate(new Language(language), text1, text2);
        }
        catch (LangridException e) {
            throw new ProcessFailedException((Throwable)e);
        }
        catch (InvalidLanguageTagException e) {
            throw new ProcessFailedException((Throwable)e);
        }
    }
}

