/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.composite.commons.test;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.function.Predicate;
import jp.go.nict.langrid.client.ClientFactory;
import jp.go.nict.langrid.client.RequestAttributes;
import jp.go.nict.langrid.commons.beanutils.Converter;
import jp.go.nict.langrid.commons.io.StreamUtil;
import jp.go.nict.langrid.commons.lang.reflect.LoggingProxy;
import jp.go.nict.langrid.commons.transformer.TransformationException;
import jp.go.nict.langrid.commons.transformer.Transformer;
import jp.go.nict.langrid.commons.util.function.Filters;
import jp.go.nict.langrid.service_1_2.typed.PartOfSpeech;

public class TestContext {
    private ClientFactory factory;
    private String baseUrl;
    private String userId;
    private String password;
    static Converter converter = new Converter();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestContext(Class<?> base, ClientFactory factory) throws IOException {
        Iterator it;
        this.factory = factory;
        InputStream is = base.getResourceAsStream("Context_url");
        if (is == null) {
            throw new RuntimeException("Context_url is needed beside the test class and also Context_auth if needed.");
        }
        try {
            it = StreamUtil.readLines((Reader)new InputStreamReader(is, "UTF-8"), (Predicate)Filters.ignoreBlankAndComment()).iterator();
            if (!it.hasNext()) {
                throw new RuntimeException("no information in Context_url");
            }
            this.baseUrl = (String)it.next();
        }
        finally {
            is.close();
        }
        is = base.getResourceAsStream("Context_auth");
        if (is == null) {
            return;
        }
        try {
            it = StreamUtil.readLines((Reader)new InputStreamReader(is, "UTF-8"), (Predicate)Filters.ignoreBlankAndComment()).iterator();
            if (it.hasNext()) {
                this.userId = (String)it.next();
            }
            if (it.hasNext()) {
                this.password = (String)it.next();
            }
        }
        finally {
            is.close();
        }
    }

    public <T> T createClient(String name, Class<T> clazz) {
        Object c = this.factory.create(clazz, this.url(name));
        RequestAttributes reqAttrs = (RequestAttributes)c;
        if (this.userId != null) {
            reqAttrs.setUserId(this.userId);
            reqAttrs.setPassword(this.password);
        }
        return (T)LoggingProxy.create((Object)c);
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getPassword() {
        return this.password;
    }

    public static Converter getConverter() {
        return converter;
    }

    private URL url(String name) {
        try {
            return new URL(this.baseUrl + name);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        converter.addTransformerConversion((Transformer)new PartOfSpeechToStringTransformer());
    }

    static class PartOfSpeechToStringTransformer
    implements Transformer<PartOfSpeech, String> {
        PartOfSpeechToStringTransformer() {
        }

        public String transform(PartOfSpeech value) throws TransformationException {
            return value.getExpression();
        }
    }
}

