/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.composite.commons.test;

import java.io.IOException;
import java.net.URL;
import jp.go.nict.langrid.client.ClientFactory;
import jp.go.nict.langrid.client.jsonrpc.JsonRpcClientFactory;
import jp.go.nict.langrid.client.ws_1_2.TranslationClient;
import jp.go.nict.langrid.client.ws_1_2.error.LangridException;
import jp.go.nict.langrid.composite.commons.test.TestContext;
import jp.go.nict.langrid.language.InvalidLanguageTagException;
import jp.go.nict.langrid.language.Language;
import jp.go.nict.langrid.service_1_2.ProcessFailedException;
import jp.go.nict.langrid.service_1_2.translation.TranslationService;

public class TranslationClientAdapter
implements TranslationService {
    private TranslationClient client;

    public TranslationClientAdapter(String serviceId) {
        try {
            TestContext tc = new TestContext(this.getClass(), (ClientFactory)new JsonRpcClientFactory());
            this.client = jp.go.nict.langrid.client.ws_1_2.ClientFactory.createTranslationClient((URL)new URL(tc.getBaseUrl() + serviceId));
            this.client.setUserId(tc.getUserId());
            this.client.setPassword(tc.getPassword());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String translate(String sourceLang, String targetLang, String source) throws ProcessFailedException {
        try {
            return this.client.translate(new Language(sourceLang), new Language(targetLang), source);
        }
        catch (LangridException e) {
            throw new ProcessFailedException((Throwable)e);
        }
        catch (InvalidLanguageTagException e) {
            throw new ProcessFailedException((Throwable)e);
        }
    }
}

