/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.composite.commons.thread;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import jp.go.nict.langrid.composite.commons.thread.Task;

public abstract class GradualTask<T>
extends Task<T>
implements Runnable {
    private LinkedBlockingQueue<T> results = new LinkedBlockingQueue();

    public List<T> getCurrentResult(int queueWaitMillis) throws Exception {
        ArrayList<T> ret = new ArrayList<T>();
        if (this.results.drainTo(ret) == 0 && !this.isDone()) {
            try {
                T r = this.results.poll(queueWaitMillis, TimeUnit.MILLISECONDS);
                if (r != null) {
                    ret.add(r);
                    this.results.drainTo(ret);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (ret.size() == 0 && this.isDone()) {
            this.throwExceptionIfOccurred();
        }
        return ret;
    }

    protected void addResult(T result) {
        this.results.add(result);
    }

    @Override
    protected abstract void doWork() throws Exception;
}

