/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.composite.commons.thread;

import java.util.ArrayList;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import jp.go.nict.langrid.commons.lang.StringUtil;
import jp.go.nict.langrid.composite.commons.thread.Task;
import jp.go.nict.langrid.composite.commons.thread.TaskRunner;

public class TaskManager {
    private Map<String, Task<?>> tokenToTask = new ConcurrentHashMap();

    public TaskManager() {
        new Timer().scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                TaskManager.this.clean();
            }
        }, 600000L, 600000L);
    }

    public <T> String addAndRunTask(Task<T> task) {
        String token;
        while (this.tokenToTask.containsKey(token = StringUtil.randomString((int)40))) {
        }
        this.tokenToTask.put(token, task);
        TaskRunner.run(task);
        return token;
    }

    public void removeTask(String token) {
        Object task = this.getTask(token);
        if (task == null) {
            return;
        }
        ((Task)task).interrupt();
        this.tokenToTask.remove(token);
    }

    public <T extends Task<?>> T getTask(String token) {
        return (T)this.tokenToTask.get(token);
    }

    public int currentTaskCount() {
        return this.tokenToTask.size();
    }

    protected void clean() {
        long current = System.currentTimeMillis();
        ArrayList<String> garbages = new ArrayList<String>();
        for (Map.Entry<String, Task<?>> entry : this.tokenToTask.entrySet()) {
            Task<?> task = entry.getValue();
            if (current - task.getStartTime() <= task.getExpirationPeriod()) continue;
            task.interrupt();
            garbages.add(entry.getKey());
        }
        for (String g : garbages) {
            this.tokenToTask.remove(g);
        }
    }
}

