/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.composite.failover;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import jp.go.nict.langrid.servicecontainer.service.ComponentServiceFactory;

public class FailoverComponentServiceFactory
implements ComponentServiceFactory {
    private ComponentServiceFactory orig;

    public FailoverComponentServiceFactory() {
    }

    public FailoverComponentServiceFactory(ComponentServiceFactory orig) {
        this.setOriginalFactory(orig);
    }

    public void setOriginalFactory(ComponentServiceFactory orig) {
        this.orig = orig;
    }

    public <T> T getService(String invocationName, Class<T> interfaceClass) {
        FailoverInvocationHandler<T> handler = new FailoverInvocationHandler<T>(invocationName, interfaceClass);
        if (((FailoverInvocationHandler)handler).getCurrentService() == null) {
            return null;
        }
        return interfaceClass.cast(Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{interfaceClass}, handler));
    }

    class FailoverInvocationHandler<T>
    implements InvocationHandler {
        private String invocationName;
        private Class<T> interfaceClass;
        private int currentIndex = 0;
        private T currentService;

        public FailoverInvocationHandler(String invocationName, Class<T> interfaceClass) {
            this.invocationName = invocationName;
            this.interfaceClass = interfaceClass;
            this.findFirstService();
        }

        private T getCurrentService() {
            return this.currentService;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Throwable firstException = null;
            int startIndex = this.currentIndex;
            while (true) {
                try {
                    return method.invoke(this.currentService, args);
                }
                catch (InvocationTargetException e) {
                    boolean found;
                    if (firstException != null) continue;
                    firstException = e.getCause();
                    if (found = this.findNextService(startIndex)) continue;
                    if (firstException != null) {
                        throw firstException;
                    }
                    throw new RuntimeException();
                }
                break;
            }
        }

        private void findFirstService() {
            this.currentService = FailoverComponentServiceFactory.this.orig.getService(this.invocationName, this.interfaceClass);
        }

        private boolean findNextService(int until) {
            block1: {
                Object s;
                do {
                    this.currentIndex = (this.currentIndex + 1) % 10;
                    if (this.currentIndex == until) break block1;
                } while ((s = FailoverComponentServiceFactory.this.orig.getService(this.invocationName + (this.currentIndex != 0 ? "Alt" + this.currentIndex : ""), this.interfaceClass)) == null);
                this.currentService = s;
                return true;
            }
            return false;
        }
    }
}

