/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.composite.commons.test;

import java.io.IOException;
import java.net.URL;
import jp.go.nict.langrid.client.ClientFactory;
import jp.go.nict.langrid.client.jsonrpc.JsonRpcClientFactory;
import jp.go.nict.langrid.client.ws_1_2.SpeechRecognitionClient;
import jp.go.nict.langrid.client.ws_1_2.error.LangridException;
import jp.go.nict.langrid.composite.commons.test.TestContext;
import jp.go.nict.langrid.service_1_2.AccessLimitExceededException;
import jp.go.nict.langrid.service_1_2.InvalidParameterException;
import jp.go.nict.langrid.service_1_2.NoAccessPermissionException;
import jp.go.nict.langrid.service_1_2.NoValidEndpointsException;
import jp.go.nict.langrid.service_1_2.ProcessFailedException;
import jp.go.nict.langrid.service_1_2.ServerBusyException;
import jp.go.nict.langrid.service_1_2.ServiceNotActiveException;
import jp.go.nict.langrid.service_1_2.ServiceNotFoundException;
import jp.go.nict.langrid.service_1_2.UnsupportedLanguageException;
import jp.go.nict.langrid.service_1_2.speech.Speech;
import jp.go.nict.langrid.service_1_2.speech.SpeechRecognitionService;

public class SpeechRecognitionClientAdapter
implements SpeechRecognitionService {
    private SpeechRecognitionClient client;

    public SpeechRecognitionClientAdapter(String serviceId) {
        try {
            TestContext tc = new TestContext(this.getClass(), (ClientFactory)new JsonRpcClientFactory());
            this.client = jp.go.nict.langrid.client.ws_1_2.ClientFactory.createSpeechRecognitionClient((URL)new URL(tc.getBaseUrl() + serviceId));
            this.client.setUserId(tc.getUserId());
            this.client.setPassword(tc.getPassword());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String recognize(String language, Speech speech) throws AccessLimitExceededException, InvalidParameterException, NoAccessPermissionException, NoValidEndpointsException, ProcessFailedException, ServerBusyException, ServiceNotActiveException, ServiceNotFoundException, UnsupportedLanguageException {
        try {
            return this.client.recognize(language, speech);
        }
        catch (LangridException e) {
            throw new ProcessFailedException((Throwable)e);
        }
    }

    public String[] getSupportedAudioTypes() throws NoValidEndpointsException, ProcessFailedException, ServerBusyException, ServiceNotActiveException, ServiceNotFoundException {
        return null;
    }

    public String[] getSupportedLanguages() throws NoValidEndpointsException, ProcessFailedException, ServerBusyException, ServiceNotActiveException, ServiceNotFoundException {
        return null;
    }

    public String[] getSupportedVoiceTypes() throws NoValidEndpointsException, ProcessFailedException, ServerBusyException, ServiceNotActiveException, ServiceNotFoundException {
        return null;
    }
}

