/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.composite.commons.test;

import java.io.IOException;
import java.net.URL;
import jp.go.nict.langrid.client.jsonrpc.JsonRpcClientFactory;
import jp.go.nict.langrid.client.ws_1_2.ClientFactory;
import jp.go.nict.langrid.client.ws_1_2.TextToSpeechClient;
import jp.go.nict.langrid.client.ws_1_2.error.LangridException;
import jp.go.nict.langrid.composite.commons.test.TestContext;
import jp.go.nict.langrid.language.InvalidLanguageTagException;
import jp.go.nict.langrid.language.Language;
import jp.go.nict.langrid.service_1_2.AccessLimitExceededException;
import jp.go.nict.langrid.service_1_2.InvalidParameterException;
import jp.go.nict.langrid.service_1_2.NoAccessPermissionException;
import jp.go.nict.langrid.service_1_2.NoValidEndpointsException;
import jp.go.nict.langrid.service_1_2.ProcessFailedException;
import jp.go.nict.langrid.service_1_2.ServerBusyException;
import jp.go.nict.langrid.service_1_2.ServiceNotActiveException;
import jp.go.nict.langrid.service_1_2.ServiceNotFoundException;
import jp.go.nict.langrid.service_1_2.UnsupportedLanguageException;
import jp.go.nict.langrid.service_1_2.speech.Speech;
import jp.go.nict.langrid.service_1_2.speech.TextToSpeechService;

public class TextToSpeechClientAdapter
implements TextToSpeechService {
    private TextToSpeechClient client;

    public TextToSpeechClientAdapter(String serviceId) {
        try {
            TestContext tc = new TestContext(this.getClass(), (jp.go.nict.langrid.client.ClientFactory)new JsonRpcClientFactory());
            this.client = ClientFactory.createTextToSpeechClient((URL)new URL(tc.getBaseUrl() + serviceId));
            this.client.setUserId(tc.getUserId());
            this.client.setPassword(tc.getPassword());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Speech speak(String language, String text, String voiceType, String audioType) throws AccessLimitExceededException, InvalidParameterException, NoAccessPermissionException, NoValidEndpointsException, ProcessFailedException, ServerBusyException, ServiceNotActiveException, ServiceNotFoundException, UnsupportedLanguageException {
        try {
            return this.client.speak(new Language(language), text, voiceType, audioType);
        }
        catch (LangridException e) {
            throw new ProcessFailedException((Throwable)e);
        }
        catch (InvalidLanguageTagException e) {
            throw new ProcessFailedException((Throwable)e);
        }
    }

    public String[] getSupportedAudioTypes() throws AccessLimitExceededException, NoAccessPermissionException, NoValidEndpointsException, ProcessFailedException, ServerBusyException, ServiceNotActiveException, ServiceNotFoundException {
        return null;
    }

    public String[] getSupportedLanguages() throws AccessLimitExceededException, NoAccessPermissionException, NoValidEndpointsException, ProcessFailedException, ServerBusyException, ServiceNotActiveException, ServiceNotFoundException {
        return null;
    }

    public String[] getSupportedVoiceTypes() throws AccessLimitExceededException, NoAccessPermissionException, NoValidEndpointsException, ProcessFailedException, ServerBusyException, ServiceNotActiveException, ServiceNotFoundException {
        return null;
    }
}

