/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.composite.commons.thread;

import jp.go.nict.langrid.commons.lang.block.BlockP;
import jp.go.nict.langrid.commons.ws.LocalServiceContext;
import jp.go.nict.langrid.commons.ws.ServiceContext;
import jp.go.nict.langrid.servicecontainer.handler.RIProcessor;
import jp.go.nict.langrid.servicecontainer.handler.RIProcessorContext;

public abstract class Task<T>
implements Runnable {
    private volatile RIProcessorContext processorContext;
    private volatile BlockP<RIProcessorContext> callback;
    private volatile long startTime = -1L;
    private volatile long expirationPeriod = 600000L;
    private volatile Thread workingThread;
    private volatile boolean done = false;
    private volatile boolean interrupted;
    private volatile Exception exception = null;

    @Override
    public void run() {
        this.startTime = System.currentTimeMillis();
        this.workingThread = Thread.currentThread();
        if (this.processorContext != null) {
            RIProcessor.fork((RIProcessorContext)this.processorContext);
        }
        try {
            this.doWork();
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            this.exception = e;
        }
        finally {
            this.done = true;
            if (this.callback != null) {
                this.callback.execute((Object)RIProcessor.join());
            } else {
                RIProcessor.join();
            }
            this.workingThread = null;
        }
    }

    public boolean isDone() {
        return this.done;
    }

    public boolean isExceptionOccurred() {
        return this.exception != null;
    }

    public void interrupt() {
        this.interrupted = true;
    }

    public boolean interrupted() {
        boolean b = this.interrupted;
        this.interrupted = false;
        return b;
    }

    protected long getStartTime() {
        return this.startTime;
    }

    public long getExpirationPeriod() {
        return this.expirationPeriod;
    }

    public void setExpirationPeriod(long expirationPeriod) {
        this.expirationPeriod = expirationPeriod;
    }

    protected Thread getWorkingThread() {
        return this.workingThread;
    }

    protected abstract void doWork() throws Exception;

    protected void throwExceptionIfOccurred() throws Exception {
        if (this.exception != null) {
            Exception e = this.exception;
            this.exception = null;
            throw e;
        }
    }

    void setUp() {
        RIProcessorContext pc = RIProcessor.getCurrentProcessorContext();
        if (pc == null) {
            return;
        }
        final ServiceContext sc = pc.getContext();
        LocalServiceContext lc = new LocalServiceContext(){

            public String getRealPath(String path) {
                return sc.getRealPath(path);
            }
        };
        lc.setRequestMimeHeaders(sc.getRequestMimeHeaders());
        lc.setRequestRpcHeaders(sc.getRequestRpcHeaders());
        this.processorContext = new RIProcessorContext((ServiceContext)lc, pc.getProcessId(), pc.getHeaderMessageHandler());
    }

    void setDoneCallback(BlockP<RIProcessorContext> callback) {
        this.callback = callback;
    }
}

