/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.composite.commons.thread;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import jp.go.nict.langrid.commons.lang.block.BlockP;
import jp.go.nict.langrid.composite.commons.thread.Task;
import jp.go.nict.langrid.composite.commons.thread.TaskRunner;
import jp.go.nict.langrid.servicecontainer.handler.RIProcessor;
import jp.go.nict.langrid.servicecontainer.handler.RIProcessorContext;

public class TaskGroup {
    private List<Task<?>> tasks = new ArrayList();
    private List<RIProcessorContext> contexts = new ArrayList<RIProcessorContext>();
    private CountDownLatch latch;

    public void add(Task<?> task) {
        this.tasks.add(task);
    }

    public void runAndWait() throws InterruptedException {
        this.latch = new CountDownLatch(this.tasks.size());
        for (Task<?> t : this.tasks) {
            t.setDoneCallback(new BlockP<RIProcessorContext>(){

                public void execute(RIProcessorContext p1) {
                    TaskGroup.this.done(p1);
                }
            });
            TaskRunner.run(t);
        }
        try {
            this.latch.await();
        }
        catch (Throwable throwable) {
            for (RIProcessorContext c : this.contexts) {
                RIProcessor.mergeContext((RIProcessorContext)c);
            }
            this.tasks.clear();
            this.contexts.clear();
            throw throwable;
        }
        for (RIProcessorContext c : this.contexts) {
            RIProcessor.mergeContext((RIProcessorContext)c);
        }
        this.tasks.clear();
        this.contexts.clear();
    }

    private synchronized void done(RIProcessorContext context) {
        this.latch.countDown();
        this.contexts.add(context);
    }
}

