/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.language;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Set;
import jp.go.nict.langrid.commons.lang.ClassResourceBundle;
import jp.go.nict.langrid.language.CountryName;
import jp.go.nict.langrid.language.IANALanguageTags;
import jp.go.nict.langrid.language.ISO3166;
import jp.go.nict.langrid.language.ISO639_1;
import jp.go.nict.langrid.language.ISO639_2;
import jp.go.nict.langrid.language.InvalidLanguageTagError;
import jp.go.nict.langrid.language.InvalidLanguageTagException;
import jp.go.nict.langrid.language.LanguageTag;

public class Language
implements Serializable {
    private String[] tags;
    private transient String code;
    private static final long serialVersionUID = 2327769078848039242L;
    private static Set<String> invalidTags = new HashSet<String>(Arrays.asList("UND", "MUL"));

    public Language(String expression) throws InvalidLanguageTagException {
        this.tags = Language.parseToTags(expression);
    }

    public int hashCode() {
        return this.getCode().hashCode();
    }

    public boolean equals(Language value) {
        assert (value != null);
        return this.getCode().toUpperCase().equals(value.getCode().toUpperCase());
    }

    public boolean equals(Object value) {
        return this.equals((Language)value);
    }

    public boolean isDeprecated() {
        return false;
    }

    public String[] getTags() {
        return this.tags;
    }

    public String getCode() {
        if (this.code != null) {
            return this.code;
        }
        StringBuilder b = new StringBuilder();
        int i = 0;
        for (String tag : this.tags) {
            if (i == 0) {
                b.append(tag.toLowerCase());
            } else if (i == 1) {
                switch (tag.length()) {
                    case 2: 
                    case 3: {
                        b.append(tag.toUpperCase());
                        break;
                    }
                    default: {
                        b.append(tag);
                        break;
                    }
                }
            } else {
                b.append(tag);
            }
            b.append("-");
            ++i;
        }
        this.code = b.deleteCharAt(b.length() - 1).toString();
        return this.code;
    }

    public String getLocalizedName(Locale locale) {
        try {
            return ClassResourceBundle.getString((Locale)locale, this.getClass(), (String)this.getCode());
        }
        catch (MissingResourceException e) {
            return this.getCode();
        }
    }

    public String toString() {
        return this.getCode();
    }

    public boolean matches(Language value) {
        if (value.getCode().equals("*")) {
            return true;
        }
        for (int i = 0; i < this.tags.length; ++i) {
            if (i == this.tags.length - 1 && this.tags[i].equals("*")) {
                return true;
            }
            if (i >= value.tags.length) {
                return false;
            }
            if (this.tags[i].equalsIgnoreCase(value.tags[i])) continue;
            return false;
        }
        return true;
    }

    public static Language get(LanguageTag language) {
        return new Language(new String[]{language.getCode()});
    }

    public static Language get(LanguageTag language, CountryName country, String ... additionals) throws InvalidLanguageTagError {
        String[] args = new String[additionals.length + 2];
        args[0] = language.getCode();
        args[1] = country.getCode();
        try {
            for (int i = 0; i < additionals.length; ++i) {
                String s = additionals[i];
                Language.assertValidSubTag(s);
                args[i + 2] = s;
            }
        }
        catch (InvalidLanguageTagException e) {
            throw new InvalidLanguageTagError(e);
        }
        return new Language(args);
    }

    public static Language get(LanguageTag language, String countryOrCharset, String ... additionals) throws InvalidLanguageTagError {
        try {
            String[] args = new String[additionals.length + 2];
            args[0] = language.getCode();
            Language.assertValidSubTag(countryOrCharset);
            args[1] = countryOrCharset;
            for (int i = 0; i < additionals.length; ++i) {
                String s = additionals[i];
                Language.assertValidSubTag(s);
                args[i + 2] = s;
            }
            return new Language(args);
        }
        catch (InvalidLanguageTagException e) {
            throw new InvalidLanguageTagError(e);
        }
    }

    public static Language parse(String[] tags) throws InvalidLanguageTagException {
        return new Language(Language.validateTags(tags));
    }

    public static Language parse(String expression) throws InvalidLanguageTagException {
        return new Language(Language.parseToTags(expression));
    }

    private static String[] parseToTags(String expression) throws InvalidLanguageTagException {
        Language lang = IANALanguageTags.get(expression);
        if (lang != null) {
            return lang.tags;
        }
        if (expression.equals("*")) {
            return new String[]{expression};
        }
        if (expression.endsWith("-")) {
            throw Language.createException("\"%s\" is not valid expression.", expression);
        }
        return Language.validateTags(expression.split("-"));
    }

    private static String[] validateTags(String[] tags) throws InvalidLanguageTagException {
        String tag = tags[0];
        if (tag.equals("x")) {
            if (tags.length == 1) {
                throw Language.createException("first tag \"%s\" is not valid expression.", tag);
            }
        } else {
            if (tag.length() == 2) {
                try {
                    tags[0] = ISO639_1.valueOf(tag.toUpperCase()).getCode();
                }
                catch (IllegalArgumentException e) {
                    throw Language.createException("\"%s\" is not in ISO639_1.", tag);
                }
            } else if (tag.length() == 3) {
                try {
                    ISO639_2 tag2 = ISO639_2.valueOf(tag.toUpperCase());
                    if (tag2.getTwoLetterCode() != null) {
                        throw Language.createException("\"%s\" must be used instead of \"%s\".", tag2.getTwoLetterCode().getCode(), tag);
                    }
                    String term = tag2.getTerminologyCode();
                    if (term != null && !term.equals(tag)) {
                        throw Language.createException("The terminology code \"%s\" must be used instead of \"%s\".", tag2.getTerminologyCode(), tag);
                    }
                    tags[0] = tag2.getCode();
                }
                catch (IllegalArgumentException e) {
                    throw Language.createException("\"%s\" is not in ISO639_2.", tag);
                }
            } else {
                throw Language.createException("\"%s\" is not a valid primary subtag.", tag);
            }
            if (tags.length != 1) {
                tag = tags[1];
                try {
                    if (tag.equals("*")) {
                        if (tags.length != 2) {
                            throw Language.createException("\"*\" is only allowed in end of the tags.", new String[0]);
                        }
                    } else {
                        tags[1] = ISO3166.valueOf(tag.toUpperCase()).getCode();
                    }
                }
                catch (IllegalArgumentException e) {
                    throw Language.createException("\"%s\" is not in ISO3166.", tag);
                }
            }
        }
        boolean first = true;
        for (String t : tags) {
            if (first) {
                Language.assertValidPrimarySubTag(t);
                first = false;
                continue;
            }
            Language.assertValidSubTag(t);
        }
        return tags;
    }

    private static InvalidLanguageTagException createException(String format, String ... args) {
        return new InvalidLanguageTagException(String.format(format, args));
    }

    private static void assertValidPrimarySubTag(String tag) throws InvalidLanguageTagException {
        if (tag.equals("*")) {
            return;
        }
        for (char c : tag.toCharArray()) {
            if (c < '\u007f' && Character.isLetterOrDigit(c)) continue;
            throw new InvalidLanguageTagException("'" + c + "' is not a valid character.");
        }
        if (tag.length() > 8) {
            throw Language.createException("sub-tag is too long. \"%s\"", tag);
        }
        if (invalidTags.contains(tag.toUpperCase())) {
            throw Language.createException("tag %s is reserved.", tag);
        }
    }

    private static void assertValidSubTag(String tag) throws InvalidLanguageTagException {
        Language.assertValidPrimarySubTag(tag);
        if (tag.length() < 2 && !tag.equals("*")) {
            throw Language.createException("sub-tag is too short. \"%s\"", tag);
        }
    }

    private Language(String[] tags) {
        this.tags = tags;
    }
}

