/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.language;

import java.util.ArrayList;
import jp.go.nict.langrid.language.InvalidLanguagePathException;
import jp.go.nict.langrid.language.InvalidLanguageTagException;
import jp.go.nict.langrid.language.Language;

@Deprecated
public class TranslationPath {
    private Language[] path;

    public TranslationPath(Language ... path) {
        this.path = path;
    }

    public int hashCode() {
        int h = 0;
        for (Language l : this.path) {
            h = h * 31 + l.hashCode();
        }
        return h;
    }

    public boolean equals(Object value) {
        return this.equals((TranslationPath)value);
    }

    public boolean equals(TranslationPath value) {
        if (this.path.length != value.path.length) {
            return false;
        }
        for (int i = 0; i < this.path.length; ++i) {
            if (this.path[i].equals(value.path[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        boolean first = true;
        for (Language language : this.path) {
            if (!first) {
                builder.append(" ");
            } else {
                first = false;
            }
            builder.append(language.getCode());
        }
        builder.append(")");
        return builder.toString();
    }

    public Language[] getLanguages() {
        return this.path;
    }

    public Language getSourceLanguage() {
        return this.path[0];
    }

    public Language getTargetLanguage() {
        return this.path[this.path.length - 1];
    }

    public static TranslationPath[] parse(String aPathExpression) throws InvalidLanguageTagException, InvalidLanguagePathException {
        int len = aPathExpression.length();
        if (aPathExpression.charAt(0) != '(') {
            throw new InvalidLanguagePathException("Translation path must start with '(': " + aPathExpression);
        }
        if (aPathExpression.charAt(1) != '(') {
            throw TranslationPath.createInvalidPathException(aPathExpression);
        }
        if (aPathExpression.charAt(len - 1) != ')') {
            throw new InvalidLanguagePathException("Translation path must end with ')'.");
        }
        if (aPathExpression.charAt(len - 2) != ')') {
            throw TranslationPath.createInvalidPathException(aPathExpression);
        }
        String expression = aPathExpression.substring(2, len - 2);
        ArrayList<TranslationPath> list = new ArrayList<TranslationPath>();
        for (String path : expression.split("\\) ?\\(")) {
            ArrayList<Language> languages = new ArrayList<Language>();
            for (String language : path.split(" ")) {
                languages.add(Language.parse(language));
            }
            list.add(new TranslationPath(languages.toArray(new Language[0])));
        }
        return list.toArray(new TranslationPath[0]);
    }

    private static InvalidLanguagePathException createInvalidPathException(String anExpression) {
        return new InvalidLanguagePathException("Translation path contains invalid expression: " + anExpression);
    }
}

