/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.language;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jp.go.nict.langrid.language.ISO639_1;
import jp.go.nict.langrid.language.LanguageTag;

public enum ISO639_2 implements LanguageTag
{
    AAR("AAR", null, ISO639_1.AA, "Afar"),
    ABK("ABK", null, ISO639_1.AB, "Abkhazian"),
    ACE("ACE", null, null, "Achinese"),
    ACH("ACH", null, null, "Acoli"),
    ADA("ADA", null, null, "Adangme"),
    ADY("ADY", null, null, "Adyghe", "Adygei"),
    AFA("AFA", null, null, "Afro-Asiatic (Other)"),
    AFH("AFH", null, null, "Afrihili"),
    AFR("AFR", null, ISO639_1.AF, "Afrikaans"),
    AIN("AIN", null, null, "Ainu"),
    AKA("AKA", null, ISO639_1.AK, "Akan"),
    AKK("AKK", null, null, "Akkadian"),
    ALB("ALB", "SQI", ISO639_1.SQ, "Albanian"),
    SQI("ALB", "SQI", ISO639_1.SQ, "Albanian"),
    ALE("ALE", null, null, "Aleut"),
    ALG("ALG", null, null, "Algonquian languages"),
    ALT("ALT", null, null, "Southern Altai"),
    AMH("AMH", null, ISO639_1.AM, "Amharic"),
    ANG("ANG", null, null, "English, Old (ca.450-1100)"),
    ANP("ANP", null, null, "Angika"),
    APA("APA", null, null, "Apache languages"),
    ARA("ARA", null, ISO639_1.AR, "Arabic"),
    ARC("ARC", null, null, "Official Aramaic (700-300 BCE)", "Imperial Aramaic (700-300 BCE)"),
    ARG("ARG", null, ISO639_1.AN, "Aragonese"),
    ARM("ARM", "HYE", ISO639_1.HY, "Armenian"),
    HYE("ARM", "HYE", ISO639_1.HY, "Armenian"),
    ARN("ARN", null, null, "Mapudungun", "Mapuche"),
    ARP("ARP", null, null, "Arapaho"),
    ART("ART", null, null, "Artificial (Other)"),
    ARW("ARW", null, null, "Arawak"),
    ASM("ASM", null, ISO639_1.AS, "Assamese"),
    AST("AST", null, null, "Asturian", "Bable", "Leonese", "Asturleonese"),
    ATH("ATH", null, null, "Athapascan languages"),
    AUS("AUS", null, null, "Australian languages"),
    AVA("AVA", null, ISO639_1.AV, "Avaric"),
    AVE("AVE", null, ISO639_1.AE, "Avestan"),
    AWA("AWA", null, null, "Awadhi"),
    AYM("AYM", null, ISO639_1.AY, "Aymara"),
    AZE("AZE", null, ISO639_1.AZ, "Azerbaijani"),
    BAD("BAD", null, null, "Banda languages"),
    BAI("BAI", null, null, "Bamileke languages"),
    BAK("BAK", null, ISO639_1.BA, "Bashkir"),
    BAL("BAL", null, null, "Baluchi"),
    BAM("BAM", null, ISO639_1.BM, "Bambara"),
    BAN("BAN", null, null, "Balinese"),
    BAQ("BAQ", "EUS", ISO639_1.EU, "Basque"),
    EUS("BAQ", "EUS", ISO639_1.EU, "Basque"),
    BAS("BAS", null, null, "Basa"),
    BAT("BAT", null, null, "Baltic (Other)"),
    BEJ("BEJ", null, null, "Beja", "Bedawiyet"),
    BEL("BEL", null, ISO639_1.BE, "Belarusian"),
    BEM("BEM", null, null, "Bemba"),
    BEN("BEN", null, ISO639_1.BN, "Bengali"),
    BER("BER", null, null, "Berber (Other)"),
    BHO("BHO", null, null, "Bhojpuri"),
    BIH("BIH", null, ISO639_1.BH, "Bihari"),
    BIK("BIK", null, null, "Bikol"),
    BIN("BIN", null, null, "Bini", "Edo"),
    BIS("BIS", null, ISO639_1.BI, "Bislama"),
    BLA("BLA", null, null, "Siksika"),
    BNT("BNT", null, null, "Bantu (Other)"),
    BOS("BOS", null, ISO639_1.BS, "Bosnian"),
    BRA("BRA", null, null, "Braj"),
    BRE("BRE", null, ISO639_1.BR, "Breton"),
    BTK("BTK", null, null, "Batak languages"),
    BUA("BUA", null, null, "Buriat"),
    BUG("BUG", null, null, "Buginese"),
    BUL("BUL", null, ISO639_1.BG, "Bulgarian"),
    BUR("BUR", "MYA", ISO639_1.MY, "Burmese"),
    MYA("BUR", "MYA", ISO639_1.MY, "Burmese"),
    BYN("BYN", null, null, "Blin", "Bilin"),
    CAD("CAD", null, null, "Caddo"),
    CAI("CAI", null, null, "Central American Indian (Other)"),
    CAR("CAR", null, null, "Galibi Carib"),
    CAT("CAT", null, ISO639_1.CA, "Catalan", "Valencian"),
    CAU("CAU", null, null, "Caucasian (Other)"),
    CEB("CEB", null, null, "Cebuano"),
    CEL("CEL", null, null, "Celtic (Other)"),
    CHA("CHA", null, ISO639_1.CH, "Chamorro"),
    CHB("CHB", null, null, "Chibcha"),
    CHE("CHE", null, ISO639_1.CE, "Chechen"),
    CHG("CHG", null, null, "Chagatai"),
    CHI("CHI", "ZHO", ISO639_1.ZH, "Chinese"),
    ZHO("CHI", "ZHO", ISO639_1.ZH, "Chinese"),
    CHK("CHK", null, null, "Chuukese"),
    CHM("CHM", null, null, "Mari"),
    CHN("CHN", null, null, "Chinook jargon"),
    CHO("CHO", null, null, "Choctaw"),
    CHP("CHP", null, null, "Chipewyan", "Dene Suline"),
    CHR("CHR", null, null, "Cherokee"),
    CHU("CHU", null, ISO639_1.CU, "Church Slavic", "Old Slavonic", "Church Slavonic", "Old Bulgarian", "Old Church Slavonic"),
    CHV("CHV", null, ISO639_1.CV, "Chuvash"),
    CHY("CHY", null, null, "Cheyenne"),
    CMC("CMC", null, null, "Chamic languages"),
    COP("COP", null, null, "Coptic"),
    COR("COR", null, ISO639_1.KW, "Cornish"),
    COS("COS", null, ISO639_1.CO, "Corsican"),
    CPE("CPE", null, null, "Creoles and pidgins, English based (Other)"),
    CPF("CPF", null, null, "Creoles and pidgins, French-based (Other)"),
    CPP("CPP", null, null, "Creoles and pidgins, Portuguese-based (Other)"),
    CRE("CRE", null, ISO639_1.CR, "Cree"),
    CRH("CRH", null, null, "Crimean Tatar", "Crimean Turkish"),
    CRP("CRP", null, null, "Creoles and pidgins (Other)"),
    CSB("CSB", null, null, "Kashubian"),
    CUS("CUS", null, null, "Cushitic (Other)"),
    CZE("CZE", "CES", ISO639_1.CS, "Czech"),
    CES("CZE", "CES", ISO639_1.CS, "Czech"),
    DAK("DAK", null, null, "Dakota"),
    DAN("DAN", null, ISO639_1.DA, "Danish"),
    DAR("DAR", null, null, "Dargwa"),
    DAY("DAY", null, null, "Land Dayak languages"),
    DEL("DEL", null, null, "Delaware"),
    DEN("DEN", null, null, "Slave (Athapascan)"),
    DGR("DGR", null, null, "Dogrib"),
    DIN("DIN", null, null, "Dinka"),
    DIV("DIV", null, ISO639_1.DV, "Divehi", "Dhivehi", "Maldivian"),
    DOI("DOI", null, null, "Dogri"),
    DRA("DRA", null, null, "Dravidian (Other)"),
    DSB("DSB", null, null, "Lower Sorbian"),
    DUA("DUA", null, null, "Duala"),
    DUM("DUM", null, null, "Dutch, Middle (ca.1050-1350)"),
    DUT("DUT", "NLD", ISO639_1.NL, "Dutch", "Flemish"),
    NLD("DUT", "NLD", ISO639_1.NL, "Dutch", "Flemish"),
    DYU("DYU", null, null, "Dyula"),
    DZO("DZO", null, ISO639_1.DZ, "Dzongkha"),
    EFI("EFI", null, null, "Efik"),
    EGY("EGY", null, null, "Egyptian (Ancient)"),
    EKA("EKA", null, null, "Ekajuk"),
    ELX("ELX", null, null, "Elamite"),
    ENG("ENG", null, ISO639_1.EN, "English"),
    ENM("ENM", null, null, "English, Middle (1100-1500)"),
    EPO("EPO", null, ISO639_1.EO, "Esperanto"),
    EST("EST", null, ISO639_1.ET, "Estonian"),
    EWE("EWE", null, ISO639_1.EE, "Ewe"),
    EWO("EWO", null, null, "Ewondo"),
    FAN("FAN", null, null, "Fang"),
    FAO("FAO", null, ISO639_1.FO, "Faroese"),
    FAT("FAT", null, null, "Fanti"),
    FIJ("FIJ", null, ISO639_1.FJ, "Fijian"),
    FIL("FIL", null, null, "Filipino", "Pilipino"),
    FIN("FIN", null, ISO639_1.FI, "Finnish"),
    FIU("FIU", null, null, "Finno-Ugrian (Other)"),
    FON("FON", null, null, "Fon"),
    FRE("FRE", "FRA", ISO639_1.FR, "French"),
    FRA("FRE", "FRA", ISO639_1.FR, "French"),
    FRM("FRM", null, null, "French, Middle (ca.1400-1600)"),
    FRO("FRO", null, null, "French, Old (842-ca.1400)"),
    FRR("FRR", null, null, "Northern Frisian"),
    FRS("FRS", null, null, "Eastern Frisian"),
    FRY("FRY", null, ISO639_1.FY, "Western Frisian"),
    FUL("FUL", null, ISO639_1.FF, "Fulah"),
    FUR("FUR", null, null, "Friulian"),
    GAA("GAA", null, null, "Ga"),
    GAY("GAY", null, null, "Gayo"),
    GBA("GBA", null, null, "Gbaya"),
    GEM("GEM", null, null, "Germanic (Other)"),
    GEO("GEO", "KAT", ISO639_1.KA, "Georgian"),
    KAT("GEO", "KAT", ISO639_1.KA, "Georgian"),
    GER("GER", "DEU", ISO639_1.DE, "German"),
    DEU("GER", "DEU", ISO639_1.DE, "German"),
    GEZ("GEZ", null, null, "Geez"),
    GIL("GIL", null, null, "Gilbertese"),
    GLA("GLA", null, ISO639_1.GD, "Gaelic", "Scottish Gaelic"),
    GLE("GLE", null, ISO639_1.GA, "Irish"),
    GLG("GLG", null, ISO639_1.GL, "Galician"),
    GLV("GLV", null, ISO639_1.GV, "Manx"),
    GMH("GMH", null, null, "German, Middle High (ca.1050-1500)"),
    GOH("GOH", null, null, "German, Old High (ca.750-1050)"),
    GON("GON", null, null, "Gondi"),
    GOR("GOR", null, null, "Gorontalo"),
    GOT("GOT", null, null, "Gothic"),
    GRB("GRB", null, null, "Grebo"),
    GRC("GRC", null, null, "Greek, Ancient (to 1453)"),
    GRE("GRE", "ELL", ISO639_1.EL, "Greek, Modern (1453-)"),
    ELL("GRE", "ELL", ISO639_1.EL, "Greek, Modern (1453-)"),
    GRN("GRN", null, ISO639_1.GN, "Guarani"),
    GSW("GSW", null, null, "Swiss German", "Alemannic", "Alsatian"),
    GUJ("GUJ", null, ISO639_1.GU, "Gujarati"),
    GWI("GWI", null, null, "Gwich'in"),
    HAI("HAI", null, null, "Haida"),
    HAT("HAT", null, ISO639_1.HT, "Haitian", "Haitian Creole"),
    HAU("HAU", null, ISO639_1.HA, "Hausa"),
    HAW("HAW", null, null, "Hawaiian"),
    HEB("HEB", null, ISO639_1.HE, "Hebrew"),
    HER("HER", null, ISO639_1.HZ, "Herero"),
    HIL("HIL", null, null, "Hiligaynon"),
    HIM("HIM", null, null, "Himachali"),
    HIN("HIN", null, ISO639_1.HI, "Hindi"),
    HIT("HIT", null, null, "Hittite"),
    HMN("HMN", null, null, "Hmong"),
    HMO("HMO", null, ISO639_1.HO, "Hiri Motu"),
    HRV("HRV", null, ISO639_1.HR, "Croatian"),
    HSB("HSB", null, null, "Upper Sorbian"),
    HUN("HUN", null, ISO639_1.HU, "Hungarian"),
    HUP("HUP", null, null, "Hupa"),
    IBA("IBA", null, null, "Iban"),
    IBO("IBO", null, ISO639_1.IG, "Igbo"),
    ICE("ICE", "ISL", ISO639_1.IS, "Icelandic"),
    ISL("ICE", "ISL", ISO639_1.IS, "Icelandic"),
    IDO("IDO", null, ISO639_1.IO, "Ido"),
    III("III", null, ISO639_1.II, "Sichuan Yi", "Nuosu"),
    IJO("IJO", null, null, "Ijo languages"),
    IKU("IKU", null, ISO639_1.IU, "Inuktitut"),
    ILE("ILE", null, ISO639_1.IE, "Interlingue", "Occidental"),
    ILO("ILO", null, null, "Iloko"),
    INA("INA", null, ISO639_1.IA, "Interlingua (International Auxiliary Language Association)"),
    INC("INC", null, null, "Indic (Other)"),
    IND("IND", null, ISO639_1.ID, "Indonesian"),
    INE("INE", null, null, "Indo-European (Other)"),
    INH("INH", null, null, "Ingush"),
    IPK("IPK", null, ISO639_1.IK, "Inupiaq"),
    IRA("IRA", null, null, "Iranian (Other)"),
    IRO("IRO", null, null, "Iroquoian languages"),
    ITA("ITA", null, ISO639_1.IT, "Italian"),
    JAV("JAV", null, ISO639_1.JV, "Javanese"),
    JBO("JBO", null, null, "Lojban"),
    JPN("JPN", null, ISO639_1.JA, "Japanese"),
    JPR("JPR", null, null, "Judeo-Persian"),
    JRB("JRB", null, null, "Judeo-Arabic"),
    KAA("KAA", null, null, "Kara-Kalpak"),
    KAB("KAB", null, null, "Kabyle"),
    KAC("KAC", null, null, "Kachin", "Jingpho"),
    KAL("KAL", null, ISO639_1.KL, "Kalaallisut", "Greenlandic"),
    KAM("KAM", null, null, "Kamba"),
    KAN("KAN", null, ISO639_1.KN, "Kannada"),
    KAR("KAR", null, null, "Karen languages"),
    KAS("KAS", null, ISO639_1.KS, "Kashmiri"),
    KAU("KAU", null, ISO639_1.KR, "Kanuri"),
    KAW("KAW", null, null, "Kawi"),
    KAZ("KAZ", null, ISO639_1.KK, "Kazakh"),
    KBD("KBD", null, null, "Kabardian"),
    KHA("KHA", null, null, "Khasi"),
    KHI("KHI", null, null, "Khoisan (Other)"),
    KHM("KHM", null, ISO639_1.KM, "Central Khmer"),
    KHO("KHO", null, null, "Khotanese", "Sakan"),
    KIK("KIK", null, ISO639_1.KI, "Kikuyu", "Gikuyu"),
    KIN("KIN", null, ISO639_1.RW, "Kinyarwanda"),
    KIR("KIR", null, ISO639_1.KY, "Kirghiz", "Kyrgyz"),
    KMB("KMB", null, null, "Kimbundu"),
    KOK("KOK", null, null, "Konkani"),
    KOM("KOM", null, ISO639_1.KV, "Komi"),
    KON("KON", null, ISO639_1.KG, "Kongo"),
    KOR("KOR", null, ISO639_1.KO, "Korean"),
    KOS("KOS", null, null, "Kosraean"),
    KPE("KPE", null, null, "Kpelle"),
    KRC("KRC", null, null, "Karachay-Balkar"),
    KRL("KRL", null, null, "Karelian"),
    KRO("KRO", null, null, "Kru languages"),
    KRU("KRU", null, null, "Kurukh"),
    KUA("KUA", null, ISO639_1.KJ, "Kuanyama", "Kwanyama"),
    KUM("KUM", null, null, "Kumyk"),
    KUR("KUR", null, ISO639_1.KU, "Kurdish"),
    KUT("KUT", null, null, "Kutenai"),
    LAD("LAD", null, null, "Ladino"),
    LAH("LAH", null, null, "Lahnda"),
    LAM("LAM", null, null, "Lamba"),
    LAO("LAO", null, ISO639_1.LO, "Lao"),
    LAT("LAT", null, ISO639_1.LA, "Latin"),
    LAV("LAV", null, ISO639_1.LV, "Latvian"),
    LEZ("LEZ", null, null, "Lezghian"),
    LIM("LIM", null, ISO639_1.LI, "Limburgan", "Limburger", "Limburgish"),
    LIN("LIN", null, ISO639_1.LN, "Lingala"),
    LIT("LIT", null, ISO639_1.LT, "Lithuanian"),
    LOL("LOL", null, null, "Mongo"),
    LOZ("LOZ", null, null, "Lozi"),
    LTZ("LTZ", null, ISO639_1.LB, "Luxembourgish", "Letzeburgesch"),
    LUA("LUA", null, null, "Luba-Lulua"),
    LUB("LUB", null, ISO639_1.LU, "Luba-Katanga"),
    LUG("LUG", null, ISO639_1.LG, "Ganda"),
    LUI("LUI", null, null, "Luiseno"),
    LUN("LUN", null, null, "Lunda"),
    LUO("LUO", null, null, "Luo (Kenya and Tanzania)"),
    LUS("LUS", null, null, "Lushai"),
    MAC("MAC", "MKD", ISO639_1.MK, "Macedonian"),
    MKD("MAC", "MKD", ISO639_1.MK, "Macedonian"),
    MAD("MAD", null, null, "Madurese"),
    MAG("MAG", null, null, "Magahi"),
    MAH("MAH", null, ISO639_1.MH, "Marshallese"),
    MAI("MAI", null, null, "Maithili"),
    MAK("MAK", null, null, "Makasar"),
    MAL("MAL", null, ISO639_1.ML, "Malayalam"),
    MAN("MAN", null, null, "Mandingo"),
    MAO("MAO", "MRI", ISO639_1.MI, "Maori"),
    MRI("MAO", "MRI", ISO639_1.MI, "Maori"),
    MAP("MAP", null, null, "Austronesian (Other)"),
    MAR("MAR", null, ISO639_1.MR, "Marathi"),
    MAS("MAS", null, null, "Masai"),
    MAY("MAY", "MSA", ISO639_1.MS, "Malay"),
    MSA("MAY", "MSA", ISO639_1.MS, "Malay"),
    MDF("MDF", null, null, "Moksha"),
    MDR("MDR", null, null, "Mandar"),
    MEN("MEN", null, null, "Mende"),
    MGA("MGA", null, null, "Irish, Middle (900-1200)"),
    MIC("MIC", null, null, "Mi'kmaq", "Micmac"),
    MIN("MIN", null, null, "Minangkabau"),
    MIS("MIS", null, null, "Uncoded languages"),
    MKH("MKH", null, null, "Mon-Khmer (Other)"),
    MLG("MLG", null, ISO639_1.MG, "Malagasy"),
    MLT("MLT", null, ISO639_1.MT, "Maltese"),
    MNC("MNC", null, null, "Manchu"),
    MNI("MNI", null, null, "Manipuri"),
    MNO("MNO", null, null, "Manobo languages"),
    MOH("MOH", null, null, "Mohawk"),
    MON("MON", null, ISO639_1.MN, "Mongolian"),
    MOS("MOS", null, null, "Mossi"),
    MUL("MUL", null, null, "Multiple languages"),
    MUN("MUN", null, null, "Munda languages"),
    MUS("MUS", null, null, "Creek"),
    MWL("MWL", null, null, "Mirandese"),
    MWR("MWR", null, null, "Marwari"),
    MYN("MYN", null, null, "Mayan languages"),
    MYV("MYV", null, null, "Erzya"),
    NAH("NAH", null, null, "Nahuatl languages"),
    NAI("NAI", null, null, "North American Indian"),
    NAP("NAP", null, null, "Neapolitan"),
    NAU("NAU", null, ISO639_1.NA, "Nauru"),
    NAV("NAV", null, ISO639_1.NV, "Navajo", "Navaho"),
    NBL("NBL", null, ISO639_1.NR, "Ndebele, South", "South Ndebele"),
    NDE("NDE", null, ISO639_1.ND, "Ndebele, North", "North Ndebele"),
    NDO("NDO", null, ISO639_1.NG, "Ndonga"),
    NDS("NDS", null, null, "Low German", "Low Saxon", "German, Low", "Saxon, Low"),
    NEP("NEP", null, ISO639_1.NE, "Nepali"),
    NEW("NEW", null, null, "Nepal Bhasa", "Newari"),
    NIA("NIA", null, null, "Nias"),
    NIC("NIC", null, null, "Niger-Kordofanian (Other)"),
    NIU("NIU", null, null, "Niuean"),
    NNO("NNO", null, ISO639_1.NN, "Norwegian Nynorsk", "Nynorsk, Norwegian"),
    NOB("NOB", null, ISO639_1.NB, "Bokm\u00e5l, Norwegian", "Norwegian Bokm\u00e5l"),
    NOG("NOG", null, null, "Nogai"),
    NON("NON", null, null, "Norse, Old"),
    NOR("NOR", null, ISO639_1.NO, "Norwegian"),
    NQO("NQO", null, null, "N'Ko"),
    NSO("NSO", null, null, "Pedi", "Sepedi", "Northern Sotho"),
    NUB("NUB", null, null, "Nubian languages"),
    NWC("NWC", null, null, "Classical Newari", "Old Newari", "Classical Nepal Bhasa"),
    NYA("NYA", null, ISO639_1.NY, "Chichewa", "Chewa", "Nyanja"),
    NYM("NYM", null, null, "Nyamwezi"),
    NYN("NYN", null, null, "Nyankole"),
    NYO("NYO", null, null, "Nyoro"),
    NZI("NZI", null, null, "Nzima"),
    OCI("OCI", null, ISO639_1.OC, "Occitan (post 1500)", "Proven\u00e7al"),
    OJI("OJI", null, ISO639_1.OJ, "Ojibwa"),
    ORI("ORI", null, ISO639_1.OR, "Oriya"),
    ORM("ORM", null, ISO639_1.OM, "Oromo"),
    OSA("OSA", null, null, "Osage"),
    OSS("OSS", null, ISO639_1.OS, "Ossetian", "Ossetic"),
    OTA("OTA", null, null, "Turkish, Ottoman (1500-1928)"),
    OTO("OTO", null, null, "Otomian languages"),
    PAA("PAA", null, null, "Papuan (Other)"),
    PAG("PAG", null, null, "Pangasinan"),
    PAL("PAL", null, null, "Pahlavi"),
    PAM("PAM", null, null, "Pampanga", "Kapampangan"),
    PAN("PAN", null, ISO639_1.PA, "Panjabi", "Punjabi"),
    PAP("PAP", null, null, "Papiamento"),
    PAU("PAU", null, null, "Palauan"),
    PEO("PEO", null, null, "Persian, Old (ca.600-400 B.C.)"),
    PER("PER", "FAS", ISO639_1.FA, "Persian"),
    FAS("PER", "FAS", ISO639_1.FA, "Persian"),
    PHI("PHI", null, null, "Philippine (Other)"),
    PHN("PHN", null, null, "Phoenician"),
    PLI("PLI", null, ISO639_1.PI, "Pali"),
    POL("POL", null, ISO639_1.PL, "Polish"),
    PON("PON", null, null, "Pohnpeian"),
    POR("POR", null, ISO639_1.PT, "Portuguese"),
    PRA("PRA", null, null, "Prakrit languages"),
    PRO("PRO", null, null, "Proven\u00e7al, Old (to 1500)"),
    PUS("PUS", null, ISO639_1.PS, "Pushto", "Pashto"),
    QUE("QUE", null, ISO639_1.QU, "Quechua"),
    RAJ("RAJ", null, null, "Rajasthani"),
    RAP("RAP", null, null, "Rapanui"),
    RAR("RAR", null, null, "Rarotongan", "Cook Islands Maori"),
    ROA("ROA", null, null, "Romance (Other)"),
    ROH("ROH", null, ISO639_1.RM, "Romansh"),
    ROM("ROM", null, null, "Romany"),
    RUM("RUM", "RON", ISO639_1.RO, "Romanian", "Moldavian", "Moldovan"),
    RON("RUM", "RON", ISO639_1.RO, "Romanian", "Moldavian", "Moldovan"),
    RUN("RUN", null, ISO639_1.RN, "Rundi"),
    RUP("RUP", null, null, "Aromanian", "Arumanian", "Macedo-Romanian"),
    RUS("RUS", null, ISO639_1.RU, "Russian"),
    SAD("SAD", null, null, "Sandawe"),
    SAG("SAG", null, ISO639_1.SG, "Sango"),
    SAH("SAH", null, null, "Yakut"),
    SAI("SAI", null, null, "South American Indian (Other)"),
    SAL("SAL", null, null, "Salishan languages"),
    SAM("SAM", null, null, "Samaritan Aramaic"),
    SAN("SAN", null, ISO639_1.SA, "Sanskrit"),
    SAS("SAS", null, null, "Sasak"),
    SAT("SAT", null, null, "Santali"),
    SCN("SCN", null, null, "Sicilian"),
    SCO("SCO", null, null, "Scots"),
    SEL("SEL", null, null, "Selkup"),
    SEM("SEM", null, null, "Semitic (Other)"),
    SGA("SGA", null, null, "Irish, Old (to 900)"),
    SGN("SGN", null, null, "Sign Languages"),
    SHN("SHN", null, null, "Shan"),
    SID("SID", null, null, "Sidamo"),
    SIN("SIN", null, ISO639_1.SI, "Sinhala", "Sinhalese"),
    SIO("SIO", null, null, "Siouan languages"),
    SIT("SIT", null, null, "Sino-Tibetan (Other)"),
    SLA("SLA", null, null, "Slavic (Other)"),
    SLO("SLO", "SLK", ISO639_1.SK, "Slovak"),
    SLK("SLO", "SLK", ISO639_1.SK, "Slovak"),
    SLV("SLV", null, ISO639_1.SL, "Slovenian"),
    SMA("SMA", null, null, "Southern Sami"),
    SME("SME", null, ISO639_1.SE, "Northern Sami"),
    SMI("SMI", null, null, "Sami languages (Other)"),
    SMJ("SMJ", null, null, "Lule Sami"),
    SMN("SMN", null, null, "Inari Sami"),
    SMO("SMO", null, ISO639_1.SM, "Samoan"),
    SMS("SMS", null, null, "Skolt Sami"),
    SNA("SNA", null, ISO639_1.SN, "Shona"),
    SND("SND", null, ISO639_1.SD, "Sindhi"),
    SNK("SNK", null, null, "Soninke"),
    SOG("SOG", null, null, "Sogdian"),
    SOM("SOM", null, ISO639_1.SO, "Somali"),
    SON("SON", null, null, "Songhai languages"),
    SOT("SOT", null, ISO639_1.ST, "Sotho, Southern"),
    SPA("SPA", null, ISO639_1.ES, "Spanish", "Castilian"),
    SRD("SRD", null, ISO639_1.SC, "Sardinian"),
    SRN("SRN", null, null, "Sranan Tongo"),
    SRP("SRP", null, ISO639_1.SR, "Serbian"),
    SRR("SRR", null, null, "Serer"),
    SSA("SSA", null, null, "Nilo-Saharan (Other)"),
    SSW("SSW", null, ISO639_1.SS, "Swati"),
    SUK("SUK", null, null, "Sukuma"),
    SUN("SUN", null, ISO639_1.SU, "Sundanese"),
    SUS("SUS", null, null, "Susu"),
    SUX("SUX", null, null, "Sumerian"),
    SWA("SWA", null, ISO639_1.SW, "Swahili"),
    SWE("SWE", null, ISO639_1.SV, "Swedish"),
    SYC("SYC", null, null, "Classical Syriac"),
    SYR("SYR", null, null, "Syriac"),
    TAH("TAH", null, ISO639_1.TY, "Tahitian"),
    TAI("TAI", null, null, "Tai (Other)"),
    TAM("TAM", null, ISO639_1.TA, "Tamil"),
    TAT("TAT", null, ISO639_1.TT, "Tatar"),
    TEL("TEL", null, ISO639_1.TE, "Telugu"),
    TEM("TEM", null, null, "Timne"),
    TER("TER", null, null, "Tereno"),
    TET("TET", null, null, "Tetum"),
    TGK("TGK", null, ISO639_1.TG, "Tajik"),
    TGL("TGL", null, ISO639_1.TL, "Tagalog"),
    THA("THA", null, ISO639_1.TH, "Thai"),
    TIB("TIB", "BOD", ISO639_1.BO, "Tibetan"),
    BOD("TIB", "BOD", ISO639_1.BO, "Tibetan"),
    TIG("TIG", null, null, "Tigre"),
    TIR("TIR", null, ISO639_1.TI, "Tigrinya"),
    TIV("TIV", null, null, "Tiv"),
    TKL("TKL", null, null, "Tokelau"),
    TLH("TLH", null, null, "Klingon", "tlhIngan-Hol"),
    TLI("TLI", null, null, "Tlingit"),
    TMH("TMH", null, null, "Tamashek"),
    TOG("TOG", null, null, "Tonga (Nyasa)"),
    TON("TON", null, ISO639_1.TO, "Tonga (Tonga Islands)"),
    TPI("TPI", null, null, "Tok Pisin"),
    TSI("TSI", null, null, "Tsimshian"),
    TSN("TSN", null, ISO639_1.TN, "Tswana"),
    TSO("TSO", null, ISO639_1.TS, "Tsonga"),
    TUK("TUK", null, ISO639_1.TK, "Turkmen"),
    TUM("TUM", null, null, "Tumbuka"),
    TUP("TUP", null, null, "Tupi languages"),
    TUR("TUR", null, ISO639_1.TR, "Turkish"),
    TUT("TUT", null, null, "Altaic (Other)"),
    TVL("TVL", null, null, "Tuvalu"),
    TWI("TWI", null, ISO639_1.TW, "Twi"),
    TYV("TYV", null, null, "Tuvinian"),
    UDM("UDM", null, null, "Udmurt"),
    UGA("UGA", null, null, "Ugaritic"),
    UIG("UIG", null, ISO639_1.UG, "Uighur", "Uyghur"),
    UKR("UKR", null, ISO639_1.UK, "Ukrainian"),
    UMB("UMB", null, null, "Umbundu"),
    UND("UND", null, null, "Undetermined"),
    URD("URD", null, ISO639_1.UR, "Urdu"),
    UZB("UZB", null, ISO639_1.UZ, "Uzbek"),
    VAI("VAI", null, null, "Vai"),
    VEN("VEN", null, ISO639_1.VE, "Venda"),
    VIE("VIE", null, ISO639_1.VI, "Vietnamese"),
    VOL("VOL", null, ISO639_1.VO, "Volap\u00fck"),
    VOT("VOT", null, null, "Votic"),
    WAK("WAK", null, null, "Wakashan languages"),
    WAL("WAL", null, null, "Walamo"),
    WAR("WAR", null, null, "Waray"),
    WAS("WAS", null, null, "Washo"),
    WEL("WEL", "CYM", ISO639_1.CY, "Welsh"),
    CYM("WEL", "CYM", ISO639_1.CY, "Welsh"),
    WEN("WEN", null, null, "Sorbian languages"),
    WLN("WLN", null, ISO639_1.WA, "Walloon"),
    WOL("WOL", null, ISO639_1.WO, "Wolof"),
    XAL("XAL", null, null, "Kalmyk", "Oirat"),
    XHO("XHO", null, ISO639_1.XH, "Xhosa"),
    YAO("YAO", null, null, "Yao"),
    YAP("YAP", null, null, "Yapese"),
    YID("YID", null, ISO639_1.YI, "Yiddish"),
    YOR("YOR", null, ISO639_1.YO, "Yoruba"),
    YPK("YPK", null, null, "Yupik languages"),
    ZAP("ZAP", null, null, "Zapotec"),
    ZBL("ZBL", null, null, "Blissymbols", "Blissymbolics", "Bliss"),
    ZEN("ZEN", null, null, "Zenaga"),
    ZHA("ZHA", null, ISO639_1.ZA, "Zhuang", "Chuang"),
    ZND("ZND", null, null, "Zande languages"),
    ZUL("ZUL", null, ISO639_1.ZU, "Zulu"),
    ZUN("ZUN", null, null, "Zuni"),
    ZXX("ZXX", null, null, "No linguistic content", "Not applicable"),
    ZZA("ZZA", null, null, "Zaza", "Dimili", "Dimli", "Kirdki", "Kirmanjki", "Zazaki");

    private String terminologyCode;
    private String bibliographicCode;
    private ISO639_1 twoLetterCode;
    private List<String> descriptions;
    private static final Collection<ISO639_2> values;

    private ISO639_2(String bibliographicCode, String terminologyCode, ISO639_1 twoLetterCode, String ... descriptions) {
        this.bibliographicCode = bibliographicCode;
        this.terminologyCode = terminologyCode;
        this.twoLetterCode = twoLetterCode;
        this.descriptions = Collections.unmodifiableList(Arrays.asList(descriptions));
    }

    @Override
    public String getCode() {
        if (this.twoLetterCode != null) {
            return this.twoLetterCode.name();
        }
        if (this.terminologyCode != null) {
            return this.terminologyCode;
        }
        return this.name();
    }

    public String getBibliographicCode() {
        return this.bibliographicCode;
    }

    public String getTerminologyCode() {
        return this.terminologyCode;
    }

    public ISO639_1 getTwoLetterCode() {
        return this.twoLetterCode;
    }

    public String getDescription() {
        return this.descriptions.get(0);
    }

    public List<String> getDescriptions() {
        return this.descriptions;
    }

    public static Collection<ISO639_2> valuesCollection() {
        return values;
    }

    static {
        values = Collections.unmodifiableCollection(Arrays.asList(ISO639_2.values()));
    }
}

