/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.language;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import jp.go.nict.langrid.language.ISO3166;
import jp.go.nict.langrid.language.ISO639_1;
import jp.go.nict.langrid.language.InvalidLanguageTagException;
import jp.go.nict.langrid.language.Language;
import jp.go.nict.langrid.language.LanguageTag;

public final class LangridLanguageTags {
    public static final Language en_US = Language.get((LanguageTag)ISO639_1.EN, ISO3166.US, new String[0]);
    public static final Language en_GB = Language.get((LanguageTag)ISO639_1.EN, ISO3166.GB, new String[0]);
    public static final Language zh_CN = Language.get((LanguageTag)ISO639_1.ZH, ISO3166.CN, new String[0]);
    public static final Language zh_TW = Language.get((LanguageTag)ISO639_1.ZH, ISO3166.TW, new String[0]);
    public static final Language zh_HK = Language.get((LanguageTag)ISO639_1.ZH, ISO3166.HK, new String[0]);
    public static final Language pt_PT = Language.get((LanguageTag)ISO639_1.PT, ISO3166.PT, new String[0]);
    public static final Language pt_BR = Language.get((LanguageTag)ISO639_1.PT, ISO3166.BR, new String[0]);
    public static final Language any;
    private static Set<Language> tags;

    public static synchronized Set<Language> values() {
        if (tags == null) {
            tags = new TreeSet<Language>(new Comparator<Language>(){

                @Override
                public int compare(Language o1, Language o2) {
                    return o1.getCode().compareTo(o2.getCode());
                }
            });
            for (Field f : LangridLanguageTags.class.getDeclaredFields()) {
                if (!f.getType().equals(Language.class)) continue;
                try {
                    tags.add((Language)f.get(null));
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            tags = Collections.unmodifiableSet(tags);
        }
        return tags;
    }

    static {
        try {
            any = new Language("*");
        }
        catch (InvalidLanguageTagException e) {
            throw new RuntimeException(e);
        }
    }
}

