/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.language;

import java.io.Serializable;
import java.util.Arrays;
import jp.go.nict.langrid.language.Language;
import jp.go.nict.langrid.language.LanguagePair;

public class LanguagePath
implements Serializable {
    private Language[] path;
    private static final long serialVersionUID = -9193840592632032332L;

    public LanguagePath(Language ... path) {
        this.path = path;
    }

    public Language getSource() {
        return this.path[0];
    }

    public Language getTarget() {
        return this.path[this.path.length - 1];
    }

    public Language[] getPath() {
        return this.path;
    }

    public LanguagePair createSourceTargetPair() {
        return new LanguagePair(this.getSource(), this.getTarget());
    }

    public LanguagePath reverse() {
        Language[] newPath = new Language[this.path.length];
        for (int i = 0; i < this.path.length; ++i) {
            newPath[i] = this.path[this.path.length - i - 1];
        }
        return new LanguagePath(newPath);
    }

    public int hashCode() {
        return Arrays.hashCode(this.path);
    }

    public boolean equals(Object value) {
        return this.equals((LanguagePath)value);
    }

    public boolean equals(LanguagePath value) {
        return Arrays.equals(this.path, value.path);
    }

    public String toCodeString(String separator) {
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (Language l : this.path) {
            if (!first) {
                b.append(separator);
            } else {
                first = false;
            }
            b.append(l.getCode());
        }
        return b.toString();
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (Language l : this.path) {
            if (!first) {
                b.append(":");
            } else {
                first = false;
            }
            b.append(l);
        }
        return b.toString();
    }
}

