/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.language.util;

import java.util.ArrayList;
import java.util.Collection;
import jp.go.nict.langrid.language.Language;
import jp.go.nict.langrid.language.LanguagePair;

public class LanguagePairUtil {
    public static String[] encodeLanguagePairArray(Collection<LanguagePair> pairs) {
        ArrayList<String> cs = new ArrayList<String>();
        for (LanguagePair l : pairs) {
            cs.add(l.toString());
        }
        return cs.toArray(new String[0]);
    }

    public static void addPair(Collection<LanguagePair> pairs, Language sourceLang, Language targetLang) {
        pairs.add(new LanguagePair(sourceLang, targetLang));
    }

    public static void addBidirectionalPair(Collection<LanguagePair> pairs, Language l1, Language l2) {
        pairs.add(new LanguagePair(l1, l2));
        pairs.add(new LanguagePair(l2, l1));
    }

    public static void addBidirectionalStarformedPairs(Collection<LanguagePair> pairs, Language centerLang, Language[] termLangs) {
        for (Language tl : termLangs) {
            LanguagePairUtil.addBidirectionalPair(pairs, centerLang, tl);
        }
    }

    public static void addBidirectionalRoundrobinformedPairs(Collection<LanguagePair> pairs, Language ... languages) {
        int n = languages.length;
        for (int i = 0; i < n - 1; ++i) {
            for (int j = i + 1; j < n; ++j) {
                LanguagePairUtil.addBidirectionalPair(pairs, languages[i], languages[j]);
            }
        }
    }
}

