/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.language;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import jp.go.nict.langrid.language.ISO3166;
import jp.go.nict.langrid.language.ISO639_1;
import jp.go.nict.langrid.language.ISO639_2;
import jp.go.nict.langrid.language.Language;
import jp.go.nict.langrid.language.LanguageTag;

public final class IANALanguageTags {
    private static LanguageTag itag = new LanguageTag(){

        @Override
        public String getCode() {
            return "i";
        }
    };
    @Deprecated
    public static final Language art_lojban = Language.get((LanguageTag)ISO639_2.ART, "lojban", new String[0]);
    public static final Language az_Arab = Language.get((LanguageTag)ISO639_1.AZ, "Arab", new String[0]);
    public static final Language az_Cyrl = Language.get((LanguageTag)ISO639_1.AZ, "Cyrl", new String[0]);
    public static final Language az_Latn = Language.get((LanguageTag)ISO639_1.AZ, "Latn", new String[0]);
    public static final Language be_Latn = Language.get((LanguageTag)ISO639_1.BE, "Latn", new String[0]);
    public static final Language bs_Cyrl = Language.get((LanguageTag)ISO639_1.BS, "Cyrl", new String[0]);
    public static final Language bs_Latn = Language.get((LanguageTag)ISO639_1.BS, "Latn", new String[0]);
    public static final Language cel_gaulish = Language.get((LanguageTag)ISO639_2.CEL, "gaulish", new String[0]);
    public static final Language de_1901 = Language.get((LanguageTag)ISO639_1.DE, "1901", new String[0]);
    public static final Language de_1996 = Language.get((LanguageTag)ISO639_1.DE, "1996", new String[0]);
    public static final Language de_AT_1901 = Language.get((LanguageTag)ISO639_1.DE, ISO3166.AT, "1901");
    public static final Language de_AT_1996 = Language.get((LanguageTag)ISO639_1.DE, ISO3166.AT, "1996");
    public static final Language de_CH_1901 = Language.get((LanguageTag)ISO639_1.DE, ISO3166.CH, "1901");
    public static final Language de_CH_1996 = Language.get((LanguageTag)ISO639_1.DE, ISO3166.CH, "1996");
    public static final Language de_DE_1901 = Language.get((LanguageTag)ISO639_1.DE, ISO3166.DE, "1901");
    public static final Language de_DE_1996 = Language.get((LanguageTag)ISO639_1.DE, ISO3166.DE, "1996");
    public static final Language el_Latn = Language.get((LanguageTag)ISO639_1.EL, "Latn", new String[0]);
    public static final Language en_boont = Language.get((LanguageTag)ISO639_1.EN, "boont", new String[0]);
    public static final Language en_GB_oed = Language.get((LanguageTag)ISO639_1.EN, ISO3166.GB, "oed");
    public static final Language en_scouse = Language.get((LanguageTag)ISO639_1.EN, "scouse", new String[0]);
    public static final Language es_419 = Language.get((LanguageTag)ISO639_1.ES, "419", new String[0]);
    public static final Language i_ami = Language.get(itag, "ami", new String[0]);
    public static final Language i_bnn = Language.get(itag, "bnn", new String[0]);
    public static final Language i_default = Language.get(itag, "default", new String[0]);
    public static final Language i_enochian = Language.get(itag, "enochian", new String[0]);
    @Deprecated
    public static final Language i_hak = Language.get(itag, "hak", new String[0]);
    @Deprecated
    public static final Language i_klingon = Language.get(itag, "klingon", new String[0]);
    @Deprecated
    public static final Language i_lux = Language.get(itag, "lux", new String[0]);
    public static final Language i_mingo = Language.get(itag, "mingo", new String[0]);
    @Deprecated
    public static final Language i_navajo = Language.get(itag, "navajo", new String[0]);
    public static final Language i_pwn = Language.get(itag, "pwn", new String[0]);
    public static final Language i_tao = Language.get(itag, "tao", new String[0]);
    public static final Language i_tay = Language.get(itag, "tay", new String[0]);
    public static final Language i_tsu = Language.get(itag, "tsu", new String[0]);
    public static final Language iu_Cans = Language.get((LanguageTag)ISO639_1.IU, "Cans", new String[0]);
    public static final Language iu_Latn = Language.get((LanguageTag)ISO639_1.IU, "Latn", new String[0]);
    public static final Language mn_Cyrl = Language.get((LanguageTag)ISO639_1.MN, "Cyrl", new String[0]);
    public static final Language mn_Mong = Language.get((LanguageTag)ISO639_1.MN, "Mong", new String[0]);
    @Deprecated
    public static final Language no_bok = Language.get((LanguageTag)ISO639_1.NO, "bok", new String[0]);
    @Deprecated
    public static final Language no_nyn = Language.get((LanguageTag)ISO639_1.NO, "nyn", new String[0]);
    public static final Language sgn_BE_fr = Language.get((LanguageTag)ISO639_2.SGN, ISO3166.BE, "fr");
    public static final Language sgn_BE_nl = Language.get((LanguageTag)ISO639_2.SGN, ISO3166.BE, "nl");
    public static final Language sgn_BR = Language.get((LanguageTag)ISO639_2.SGN, ISO3166.BR, new String[0]);
    public static final Language sgn_CH_de = Language.get((LanguageTag)ISO639_2.SGN, ISO3166.CH, "de");
    public static final Language sgn_CO = Language.get((LanguageTag)ISO639_2.SGN, ISO3166.CO, new String[0]);
    public static final Language sgn_DE = Language.get((LanguageTag)ISO639_2.SGN, ISO3166.DE, new String[0]);
    public static final Language sgn_DK = Language.get((LanguageTag)ISO639_2.SGN, ISO3166.DK, new String[0]);
    public static final Language sgn_ES = Language.get((LanguageTag)ISO639_2.SGN, ISO3166.ES, new String[0]);
    public static final Language sgn_FR = Language.get((LanguageTag)ISO639_2.SGN, ISO3166.FR, new String[0]);
    public static final Language sgn_GB = Language.get((LanguageTag)ISO639_2.SGN, ISO3166.GB, new String[0]);
    public static final Language sgn_GR = Language.get((LanguageTag)ISO639_2.SGN, ISO3166.GR, new String[0]);
    public static final Language sgn_IE = Language.get((LanguageTag)ISO639_2.SGN, ISO3166.IE, new String[0]);
    public static final Language sgn_IT = Language.get((LanguageTag)ISO639_2.SGN, ISO3166.IT, new String[0]);
    public static final Language sgn_JP = Language.get((LanguageTag)ISO639_2.SGN, ISO3166.JP, new String[0]);
    public static final Language sgn_MX = Language.get((LanguageTag)ISO639_2.SGN, ISO3166.MX, new String[0]);
    public static final Language sgn_NI = Language.get((LanguageTag)ISO639_2.SGN, ISO3166.NI, new String[0]);
    public static final Language sgn_NL = Language.get((LanguageTag)ISO639_2.SGN, ISO3166.NL, new String[0]);
    public static final Language sgn_NO = Language.get((LanguageTag)ISO639_2.SGN, ISO3166.NO, new String[0]);
    public static final Language sgn_PT = Language.get((LanguageTag)ISO639_2.SGN, ISO3166.PT, new String[0]);
    public static final Language sgn_SE = Language.get((LanguageTag)ISO639_2.SGN, ISO3166.SE, new String[0]);
    public static final Language sgn_US = Language.get((LanguageTag)ISO639_2.SGN, ISO3166.US, new String[0]);
    public static final Language sgn_ZA = Language.get((LanguageTag)ISO639_2.SGN, ISO3166.ZA, new String[0]);
    public static final Language sl_nedis = Language.get((LanguageTag)ISO639_1.SL, "nedis", new String[0]);
    public static final Language sl_rozaj = Language.get((LanguageTag)ISO639_1.SL, "rozaj", new String[0]);
    public static final Language sr_Cyrl = Language.get((LanguageTag)ISO639_1.SR, "Cyrl", new String[0]);
    public static final Language sr_Latn = Language.get((LanguageTag)ISO639_1.SR, "Latn", new String[0]);
    public static final Language tg_Arab = Language.get((LanguageTag)ISO639_1.TG, "Arab", new String[0]);
    public static final Language tg_Cyrl = Language.get((LanguageTag)ISO639_1.TG, "Cyrl", new String[0]);
    public static final Language uz_Cyrl = Language.get((LanguageTag)ISO639_1.UZ, "Cyrl", new String[0]);
    public static final Language uz_Latn = Language.get((LanguageTag)ISO639_1.UZ, "Latn", new String[0]);
    public static final Language yi_latn = Language.get((LanguageTag)ISO639_1.YI, "latn", new String[0]);
    public static final Language zh_cmn = Language.get((LanguageTag)ISO639_1.ZH, "cmn", new String[0]);
    public static final Language zh_cmn_Hans = Language.get((LanguageTag)ISO639_1.ZH, "cmn", "Hans");
    public static final Language zh_cmn_Hant = Language.get((LanguageTag)ISO639_1.ZH, "cmn", "Hant");
    public static final Language zh_Hans = Language.get((LanguageTag)ISO639_1.ZH, "Hans", new String[0]);
    public static final Language zh_Hans_CN = Language.get((LanguageTag)ISO639_1.ZH, "Hans", "CN");
    public static final Language zh_Hans_HK = Language.get((LanguageTag)ISO639_1.ZH, "Hans", "HK");
    public static final Language zh_Hans_MO = Language.get((LanguageTag)ISO639_1.ZH, "Hans", "MO");
    public static final Language zh_Hans_SG = Language.get((LanguageTag)ISO639_1.ZH, "Hans", "SG");
    public static final Language zh_Hans_TW = Language.get((LanguageTag)ISO639_1.ZH, "Hans", "TW");
    public static final Language zh_Hant = Language.get((LanguageTag)ISO639_1.ZH, "Hant", new String[0]);
    public static final Language zh_Hant_CN = Language.get((LanguageTag)ISO639_1.ZH, "Hant", "CN");
    public static final Language zh_Hant_HK = Language.get((LanguageTag)ISO639_1.ZH, "Hant", "HK");
    public static final Language zh_Hant_MO = Language.get((LanguageTag)ISO639_1.ZH, "Hant", "MO");
    public static final Language zh_Hant_SG = Language.get((LanguageTag)ISO639_1.ZH, "Hant", "SG");
    public static final Language zh_Hant_TW = Language.get((LanguageTag)ISO639_1.ZH, "Hant", "TW");
    public static final Language zh_gan = Language.get((LanguageTag)ISO639_1.ZH, "gan", new String[0]);
    @Deprecated
    public static final Language zh_guoyu = Language.get((LanguageTag)ISO639_1.ZH, "guoyu", new String[0]);
    public static final Language zh_hakka = Language.get((LanguageTag)ISO639_1.ZH, "hakka", new String[0]);
    public static final Language zh_min = Language.get((LanguageTag)ISO639_1.ZH, "min", new String[0]);
    public static final Language zh_min_nan = Language.get((LanguageTag)ISO639_1.ZH, "min", "nan");
    public static final Language zh_wuu = Language.get((LanguageTag)ISO639_1.ZH, "wuu", new String[0]);
    public static final Language zh_xiang = Language.get((LanguageTag)ISO639_1.ZH, "xiang", new String[0]);
    public static final Language zh_yue = Language.get((LanguageTag)ISO639_1.ZH, "yue", new String[0]);
    private static Map<String, Language> capitalToLanguage = new LinkedHashMap<String, Language>();
    private static Map<String, Object> capitalToDescription = new HashMap<String, Object>();
    private static Set<Language> values = new LinkedHashSet<Language>();

    static {
        capitalToLanguage.put(art_lojban.getCode().toUpperCase(), art_lojban);
        capitalToDescription.put(art_lojban.getCode().toUpperCase(), new String[]{"Lojban"});
        capitalToLanguage.put(az_Arab.getCode().toUpperCase(), az_Arab);
        capitalToDescription.put(az_Arab.getCode().toUpperCase(), new String[]{"Azerbaijani in Arabic script"});
        capitalToLanguage.put(az_Cyrl.getCode().toUpperCase(), az_Cyrl);
        capitalToDescription.put(az_Cyrl.getCode().toUpperCase(), new String[]{"Azerbaijani in Cyrillic script"});
        capitalToLanguage.put(az_Latn.getCode().toUpperCase(), az_Latn);
        capitalToDescription.put(az_Latn.getCode().toUpperCase(), new String[]{"Azerbaijani in Latin script"});
        capitalToLanguage.put(be_Latn.getCode().toUpperCase(), be_Latn);
        capitalToDescription.put(be_Latn.getCode().toUpperCase(), new String[]{"Belarusian in Latin script"});
        capitalToLanguage.put(bs_Cyrl.getCode().toUpperCase(), bs_Cyrl);
        capitalToDescription.put(bs_Cyrl.getCode().toUpperCase(), new String[]{"Bosnian in Cyrillic script"});
        capitalToLanguage.put(bs_Latn.getCode().toUpperCase(), bs_Latn);
        capitalToDescription.put(bs_Latn.getCode().toUpperCase(), new String[]{"Bosnian in Latin script"});
        capitalToLanguage.put(cel_gaulish.getCode().toUpperCase(), cel_gaulish);
        capitalToDescription.put(cel_gaulish.getCode().toUpperCase(), new String[]{"Gaulish"});
        capitalToLanguage.put(de_1901.getCode().toUpperCase(), de_1901);
        capitalToDescription.put(de_1901.getCode().toUpperCase(), new String[]{"German", "traditional orthography"});
        capitalToLanguage.put(de_1996.getCode().toUpperCase(), de_1996);
        capitalToDescription.put(de_1996.getCode().toUpperCase(), new String[]{"German", "orthography of 1996"});
        capitalToLanguage.put(de_AT_1901.getCode().toUpperCase(), de_AT_1901);
        capitalToDescription.put(de_AT_1901.getCode().toUpperCase(), new String[]{"German", "Austrian variant", "traditional orthography"});
        capitalToLanguage.put(de_AT_1996.getCode().toUpperCase(), de_AT_1996);
        capitalToDescription.put(de_AT_1996.getCode().toUpperCase(), new String[]{"German", "Austrian variant", "orthography of 1996"});
        capitalToLanguage.put(de_CH_1901.getCode().toUpperCase(), de_CH_1901);
        capitalToDescription.put(de_CH_1901.getCode().toUpperCase(), new String[]{"German", "Swiss variant", "traditional orthography"});
        capitalToLanguage.put(de_CH_1996.getCode().toUpperCase(), de_CH_1996);
        capitalToDescription.put(de_CH_1996.getCode().toUpperCase(), new String[]{"German", "Swiss variant", "orthography of 1996"});
        capitalToLanguage.put(de_DE_1901.getCode().toUpperCase(), de_DE_1901);
        capitalToDescription.put(de_DE_1901.getCode().toUpperCase(), new String[]{"German", "German variant", "traditional orthography"});
        capitalToLanguage.put(de_DE_1996.getCode().toUpperCase(), de_DE_1996);
        capitalToDescription.put(de_DE_1996.getCode().toUpperCase(), new String[]{"German", "German variant", "orthography of 1996"});
        capitalToLanguage.put(el_Latn.getCode().toUpperCase(), el_Latn);
        capitalToDescription.put(el_Latn.getCode().toUpperCase(), new String[]{"Greek in Latin script"});
        capitalToLanguage.put(en_boont.getCode().toUpperCase(), en_boont);
        capitalToDescription.put(en_boont.getCode().toUpperCase(), new String[]{"Boontling"});
        capitalToLanguage.put(en_GB_oed.getCode().toUpperCase(), en_GB_oed);
        capitalToDescription.put(en_GB_oed.getCode().toUpperCase(), new String[]{"English", "Oxford English Dictionary spell"});
        capitalToLanguage.put(en_scouse.getCode().toUpperCase(), en_scouse);
        capitalToDescription.put(en_scouse.getCode().toUpperCase(), new String[]{"English Liverpudlian dialect known as 'Scouse'"});
        capitalToLanguage.put(es_419.getCode().toUpperCase(), es_419);
        capitalToDescription.put(es_419.getCode().toUpperCase(), new String[]{"Latin American Spanish"});
        capitalToLanguage.put(i_ami.getCode().toUpperCase(), i_ami);
        capitalToDescription.put(i_ami.getCode().toUpperCase(), new String[]{"Amis"});
        capitalToLanguage.put(i_bnn.getCode().toUpperCase(), i_bnn);
        capitalToDescription.put(i_bnn.getCode().toUpperCase(), new String[]{"Bunun"});
        capitalToLanguage.put(i_default.getCode().toUpperCase(), i_default);
        capitalToDescription.put(i_default.getCode().toUpperCase(), new String[]{"Default Language Context"});
        capitalToLanguage.put(i_enochian.getCode().toUpperCase(), i_enochian);
        capitalToDescription.put(i_enochian.getCode().toUpperCase(), new String[]{"Enochian"});
        capitalToLanguage.put(i_hak.getCode().toUpperCase(), i_hak);
        capitalToDescription.put(i_hak.getCode().toUpperCase(), new String[]{"Hakka"});
        capitalToLanguage.put(i_klingon.getCode().toUpperCase(), i_klingon);
        capitalToDescription.put(i_klingon.getCode().toUpperCase(), new String[]{"Klingon"});
        capitalToLanguage.put(i_lux.getCode().toUpperCase(), i_lux);
        capitalToDescription.put(i_lux.getCode().toUpperCase(), new String[]{"Luxembourgish"});
        capitalToLanguage.put(i_mingo.getCode().toUpperCase(), i_mingo);
        capitalToDescription.put(i_mingo.getCode().toUpperCase(), new String[]{"Mingo"});
        capitalToLanguage.put(i_navajo.getCode().toUpperCase(), i_navajo);
        capitalToDescription.put(i_navajo.getCode().toUpperCase(), new String[]{"Navajo"});
        capitalToLanguage.put(i_pwn.getCode().toUpperCase(), i_pwn);
        capitalToDescription.put(i_pwn.getCode().toUpperCase(), new String[]{"Paiwan"});
        capitalToLanguage.put(i_tao.getCode().toUpperCase(), i_tao);
        capitalToDescription.put(i_tao.getCode().toUpperCase(), new String[]{"Tao"});
        capitalToLanguage.put(i_tay.getCode().toUpperCase(), i_tay);
        capitalToDescription.put(i_tay.getCode().toUpperCase(), new String[]{"Tayal"});
        capitalToLanguage.put(i_tsu.getCode().toUpperCase(), i_tsu);
        capitalToDescription.put(i_tsu.getCode().toUpperCase(), new String[]{"Tsou"});
        capitalToLanguage.put(iu_Cans.getCode().toUpperCase(), iu_Cans);
        capitalToDescription.put(iu_Cans.getCode().toUpperCase(), new String[]{"Inuktitut in Canadian Aboriginal"});
        capitalToLanguage.put(iu_Latn.getCode().toUpperCase(), iu_Latn);
        capitalToDescription.put(iu_Latn.getCode().toUpperCase(), new String[]{"Inuktitut in Latin script"});
        capitalToLanguage.put(mn_Cyrl.getCode().toUpperCase(), mn_Cyrl);
        capitalToDescription.put(mn_Cyrl.getCode().toUpperCase(), new String[]{"Mongolian in Cyrillic script"});
        capitalToLanguage.put(mn_Mong.getCode().toUpperCase(), mn_Mong);
        capitalToDescription.put(mn_Mong.getCode().toUpperCase(), new String[]{"Mongolian in Mongolian script"});
        capitalToLanguage.put(no_bok.getCode().toUpperCase(), no_bok);
        capitalToDescription.put(no_bok.getCode().toUpperCase(), new String[]{"Norwegian \"Book language\""});
        capitalToLanguage.put(no_nyn.getCode().toUpperCase(), no_nyn);
        capitalToDescription.put(no_nyn.getCode().toUpperCase(), new String[]{"Norwegian \"New Norwegian\""});
        capitalToLanguage.put(sgn_BE_fr.getCode().toUpperCase(), sgn_BE_fr);
        capitalToDescription.put(sgn_BE_fr.getCode().toUpperCase(), new String[]{"Belgian-French Sign Language"});
        capitalToLanguage.put(sgn_BE_nl.getCode().toUpperCase(), sgn_BE_nl);
        capitalToDescription.put(sgn_BE_nl.getCode().toUpperCase(), new String[]{"Belgian-Flemish Sign Language"});
        capitalToLanguage.put(sgn_BR.getCode().toUpperCase(), sgn_BR);
        capitalToDescription.put(sgn_BR.getCode().toUpperCase(), new String[]{"Brazilian Sign Language"});
        capitalToLanguage.put(sgn_CH_de.getCode().toUpperCase(), sgn_CH_de);
        capitalToDescription.put(sgn_CH_de.getCode().toUpperCase(), new String[]{"Swiss German Sign Language"});
        capitalToLanguage.put(sgn_CO.getCode().toUpperCase(), sgn_CO);
        capitalToDescription.put(sgn_CO.getCode().toUpperCase(), new String[]{"Colombian Sign Language"});
        capitalToLanguage.put(sgn_DE.getCode().toUpperCase(), sgn_DE);
        capitalToDescription.put(sgn_DE.getCode().toUpperCase(), new String[]{"German Sign Language"});
        capitalToLanguage.put(sgn_DK.getCode().toUpperCase(), sgn_DK);
        capitalToDescription.put(sgn_DK.getCode().toUpperCase(), new String[]{"Danish Sign Language"});
        capitalToLanguage.put(sgn_ES.getCode().toUpperCase(), sgn_ES);
        capitalToDescription.put(sgn_ES.getCode().toUpperCase(), new String[]{"Spanish Sign Language"});
        capitalToLanguage.put(sgn_FR.getCode().toUpperCase(), sgn_FR);
        capitalToDescription.put(sgn_FR.getCode().toUpperCase(), new String[]{"French Sign Language"});
        capitalToLanguage.put(sgn_GB.getCode().toUpperCase(), sgn_GB);
        capitalToDescription.put(sgn_GB.getCode().toUpperCase(), new String[]{"British Sign Language"});
        capitalToLanguage.put(sgn_GR.getCode().toUpperCase(), sgn_GR);
        capitalToDescription.put(sgn_GR.getCode().toUpperCase(), new String[]{"Greek Sign Language"});
        capitalToLanguage.put(sgn_IE.getCode().toUpperCase(), sgn_IE);
        capitalToDescription.put(sgn_IE.getCode().toUpperCase(), new String[]{"Irish Sign Language"});
        capitalToLanguage.put(sgn_IT.getCode().toUpperCase(), sgn_IT);
        capitalToDescription.put(sgn_IT.getCode().toUpperCase(), new String[]{"Italian Sign Language"});
        capitalToLanguage.put(sgn_JP.getCode().toUpperCase(), sgn_JP);
        capitalToDescription.put(sgn_JP.getCode().toUpperCase(), new String[]{"Japanese Sign Language"});
        capitalToLanguage.put(sgn_MX.getCode().toUpperCase(), sgn_MX);
        capitalToDescription.put(sgn_MX.getCode().toUpperCase(), new String[]{"Mexican Sign Language"});
        capitalToLanguage.put(sgn_NI.getCode().toUpperCase(), sgn_NI);
        capitalToDescription.put(sgn_NI.getCode().toUpperCase(), new String[]{"Nicaraguan Sign Language"});
        capitalToLanguage.put(sgn_NL.getCode().toUpperCase(), sgn_NL);
        capitalToDescription.put(sgn_NL.getCode().toUpperCase(), new String[]{"Dutch Sign Language"});
        capitalToLanguage.put(sgn_NO.getCode().toUpperCase(), sgn_NO);
        capitalToDescription.put(sgn_NO.getCode().toUpperCase(), new String[]{"Norwegian Sign Language"});
        capitalToLanguage.put(sgn_PT.getCode().toUpperCase(), sgn_PT);
        capitalToDescription.put(sgn_PT.getCode().toUpperCase(), new String[]{"Portuguese Sign Language"});
        capitalToLanguage.put(sgn_SE.getCode().toUpperCase(), sgn_SE);
        capitalToDescription.put(sgn_SE.getCode().toUpperCase(), new String[]{"Swedish Sign Language"});
        capitalToLanguage.put(sgn_US.getCode().toUpperCase(), sgn_US);
        capitalToDescription.put(sgn_US.getCode().toUpperCase(), new String[]{"American Sign Language"});
        capitalToLanguage.put(sgn_ZA.getCode().toUpperCase(), sgn_ZA);
        capitalToDescription.put(sgn_ZA.getCode().toUpperCase(), new String[]{"South African Sign Language"});
        capitalToLanguage.put(sl_nedis.getCode().toUpperCase(), sl_nedis);
        capitalToDescription.put(sl_nedis.getCode().toUpperCase(), new String[]{"Natisone dialect", "Nadiza dialect"});
        capitalToLanguage.put(sl_rozaj.getCode().toUpperCase(), sl_rozaj);
        capitalToDescription.put(sl_rozaj.getCode().toUpperCase(), new String[]{"Resian", "Resianic", "Rezijan"});
        capitalToLanguage.put(sr_Cyrl.getCode().toUpperCase(), sr_Cyrl);
        capitalToDescription.put(sr_Cyrl.getCode().toUpperCase(), new String[]{"Serbian in Cyrillic script"});
        capitalToLanguage.put(sr_Latn.getCode().toUpperCase(), sr_Latn);
        capitalToDescription.put(sr_Latn.getCode().toUpperCase(), new String[]{"Serbian in Latin script"});
        capitalToLanguage.put(tg_Arab.getCode().toUpperCase(), tg_Arab);
        capitalToDescription.put(tg_Arab.getCode().toUpperCase(), new String[]{"Tajik in Arabic script"});
        capitalToLanguage.put(tg_Cyrl.getCode().toUpperCase(), tg_Cyrl);
        capitalToDescription.put(tg_Cyrl.getCode().toUpperCase(), new String[]{"Tajik in Cyrillic script"});
        capitalToLanguage.put(uz_Cyrl.getCode().toUpperCase(), uz_Cyrl);
        capitalToDescription.put(uz_Cyrl.getCode().toUpperCase(), new String[]{"Uzbek in Cyrillic script"});
        capitalToLanguage.put(uz_Latn.getCode().toUpperCase(), uz_Latn);
        capitalToDescription.put(uz_Latn.getCode().toUpperCase(), new String[]{"Uzbek in Latin script"});
        capitalToLanguage.put(yi_latn.getCode().toUpperCase(), yi_latn);
        capitalToDescription.put(yi_latn.getCode().toUpperCase(), new String[]{"Yiddish", "in Latin script"});
        capitalToLanguage.put(zh_cmn.getCode().toUpperCase(), zh_cmn);
        capitalToDescription.put(zh_cmn.getCode().toUpperCase(), new String[]{"Mandarin Chinese"});
        capitalToLanguage.put(zh_cmn_Hans.getCode().toUpperCase(), zh_cmn_Hans);
        capitalToDescription.put(zh_cmn_Hans.getCode().toUpperCase(), new String[]{"Mandarin Chinese (Simplified)"});
        capitalToLanguage.put(zh_cmn_Hant.getCode().toUpperCase(), zh_cmn_Hant);
        capitalToDescription.put(zh_cmn_Hant.getCode().toUpperCase(), new String[]{"Mandarin Chinese (Traditional)"});
        capitalToLanguage.put(zh_Hans.getCode().toUpperCase(), zh_Hans);
        capitalToDescription.put(zh_Hans.getCode().toUpperCase(), new String[]{"Chinese", "in simplified script"});
        capitalToLanguage.put(zh_Hans_CN.getCode().toUpperCase(), zh_Hans_CN);
        capitalToDescription.put(zh_Hans_CN.getCode().toUpperCase(), new String[]{"PRC Mainland Chinese in simplified scrip"});
        capitalToLanguage.put(zh_Hans_HK.getCode().toUpperCase(), zh_Hans_HK);
        capitalToDescription.put(zh_Hans_HK.getCode().toUpperCase(), new String[]{"Hong Kong Chinese in simplified script"});
        capitalToLanguage.put(zh_Hans_MO.getCode().toUpperCase(), zh_Hans_MO);
        capitalToDescription.put(zh_Hans_MO.getCode().toUpperCase(), new String[]{"Macao Chinese in simplified script"});
        capitalToLanguage.put(zh_Hans_SG.getCode().toUpperCase(), zh_Hans_SG);
        capitalToDescription.put(zh_Hans_SG.getCode().toUpperCase(), new String[]{"Singapore Chinese in simplified script"});
        capitalToLanguage.put(zh_Hans_TW.getCode().toUpperCase(), zh_Hans_TW);
        capitalToDescription.put(zh_Hans_TW.getCode().toUpperCase(), new String[]{"Taiwan Chinese in simplified script"});
        capitalToLanguage.put(zh_Hant.getCode().toUpperCase(), zh_Hant);
        capitalToDescription.put(zh_Hant.getCode().toUpperCase(), new String[]{"Chinese", "in traditional script"});
        capitalToLanguage.put(zh_Hant_CN.getCode().toUpperCase(), zh_Hant_CN);
        capitalToDescription.put(zh_Hant_CN.getCode().toUpperCase(), new String[]{"PRC Mainland Chinese in traditional scri"});
        capitalToLanguage.put(zh_Hant_HK.getCode().toUpperCase(), zh_Hant_HK);
        capitalToDescription.put(zh_Hant_HK.getCode().toUpperCase(), new String[]{"Hong Kong Chinese in traditional script"});
        capitalToLanguage.put(zh_Hant_MO.getCode().toUpperCase(), zh_Hant_MO);
        capitalToDescription.put(zh_Hant_MO.getCode().toUpperCase(), new String[]{"Macao Chinese in traditional script"});
        capitalToLanguage.put(zh_Hant_SG.getCode().toUpperCase(), zh_Hant_SG);
        capitalToDescription.put(zh_Hant_SG.getCode().toUpperCase(), new String[]{"Singapore Chinese in traditional script"});
        capitalToLanguage.put(zh_Hant_TW.getCode().toUpperCase(), zh_Hant_TW);
        capitalToDescription.put(zh_Hant_TW.getCode().toUpperCase(), new String[]{"Taiwan Chinese in traditional script"});
        capitalToLanguage.put(zh_gan.getCode().toUpperCase(), zh_gan);
        capitalToDescription.put(zh_gan.getCode().toUpperCase(), new String[]{"Kan or Gan"});
        capitalToLanguage.put(zh_guoyu.getCode().toUpperCase(), zh_guoyu);
        capitalToDescription.put(zh_guoyu.getCode().toUpperCase(), new String[]{"Mandarin or Standard Chinese"});
        capitalToLanguage.put(zh_hakka.getCode().toUpperCase(), zh_hakka);
        capitalToDescription.put(zh_hakka.getCode().toUpperCase(), new String[]{"Hakka"});
        capitalToLanguage.put(zh_min.getCode().toUpperCase(), zh_min);
        capitalToDescription.put(zh_min.getCode().toUpperCase(), new String[]{"Min", "Fuzhou", "Hokkien", "Amoy or Taiwanese"});
        capitalToLanguage.put(zh_min_nan.getCode().toUpperCase(), zh_min_nan);
        capitalToDescription.put(zh_min_nan.getCode().toUpperCase(), new String[]{"Minnan", "Hokkien", "Amoy", "Taiwanese", "Southern Min", "Southern Fujian", "Hoklo", "Southern Fukien", "Ho-lo"});
        capitalToLanguage.put(zh_wuu.getCode().toUpperCase(), zh_wuu);
        capitalToDescription.put(zh_wuu.getCode().toUpperCase(), new String[]{"Shanghaiese or Wu"});
        capitalToLanguage.put(zh_xiang.getCode().toUpperCase(), zh_xiang);
        capitalToDescription.put(zh_xiang.getCode().toUpperCase(), new String[]{"Xiang or Hunanese"});
        capitalToLanguage.put(zh_yue.getCode().toUpperCase(), zh_yue);
        capitalToDescription.put(zh_yue.getCode().toUpperCase(), new String[]{"Cantonese"});
        capitalToLanguage = Collections.unmodifiableMap(capitalToLanguage);
        values.addAll(capitalToLanguage.values());
    }

    public static Language get(String languageExpression) {
        return capitalToLanguage.get(languageExpression.toUpperCase());
    }

    public static String[] getDescriptions(Language language) {
        return (String[])capitalToDescription.get(language.getCode().toUpperCase());
    }

    public static Set<Language> values() {
        return values;
    }
}

