/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.language;

import java.util.ArrayList;
import jp.go.nict.langrid.language.InvalidLanguagePathException;
import jp.go.nict.langrid.language.InvalidLanguageTagException;
import jp.go.nict.langrid.language.Language;

@Deprecated
public class TranslationPath {
    private Language[] path;

    public TranslationPath(Language ... path) {
        this.path = path;
    }

    public int hashCode() {
        int h = 0;
        Language[] languageArray = this.path;
        int n = this.path.length;
        int n2 = 0;
        while (n2 < n) {
            Language l = languageArray[n2];
            h = h * 31 + l.hashCode();
            ++n2;
        }
        return h;
    }

    public boolean equals(Object value) {
        return this.equals((TranslationPath)value);
    }

    public boolean equals(TranslationPath value) {
        if (this.path.length != value.path.length) {
            return false;
        }
        int i = 0;
        while (i < this.path.length) {
            if (!this.path[i].equals(value.path[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        boolean first = true;
        Language[] languageArray = this.path;
        int n = this.path.length;
        int n2 = 0;
        while (n2 < n) {
            Language language = languageArray[n2];
            if (!first) {
                builder.append(" ");
            } else {
                first = false;
            }
            builder.append(language.getCode());
            ++n2;
        }
        builder.append(")");
        return builder.toString();
    }

    public Language[] getLanguages() {
        return this.path;
    }

    public Language getSourceLanguage() {
        return this.path[0];
    }

    public Language getTargetLanguage() {
        return this.path[this.path.length - 1];
    }

    public static TranslationPath[] parse(String aPathExpression) throws InvalidLanguageTagException, InvalidLanguagePathException {
        int len = aPathExpression.length();
        if (aPathExpression.charAt(0) != '(') {
            throw new InvalidLanguagePathException("Translation path must start with '(': " + aPathExpression);
        }
        if (aPathExpression.charAt(1) != '(') {
            throw TranslationPath.createInvalidPathException(aPathExpression);
        }
        if (aPathExpression.charAt(len - 1) != ')') {
            throw new InvalidLanguagePathException("Translation path must end with ')'.");
        }
        if (aPathExpression.charAt(len - 2) != ')') {
            throw TranslationPath.createInvalidPathException(aPathExpression);
        }
        String expression = aPathExpression.substring(2, len - 2);
        ArrayList<TranslationPath> list = new ArrayList<TranslationPath>();
        String[] stringArray = expression.split("\\) ?\\(");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            ArrayList<Language> languages = new ArrayList<Language>();
            String[] stringArray2 = path.split(" ");
            int n3 = stringArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                String language = stringArray2[n4];
                languages.add(Language.parse(language));
                ++n4;
            }
            list.add(new TranslationPath(languages.toArray(new Language[0])));
            ++n2;
        }
        return list.toArray(new TranslationPath[0]);
    }

    private static InvalidLanguagePathException createInvalidPathException(String anExpression) {
        return new InvalidLanguagePathException("Translation path contains invalid expression: " + anExpression);
    }
}

