/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.language.util;

import java.util.ArrayList;
import java.util.Collection;
import jp.go.nict.langrid.language.Language;
import jp.go.nict.langrid.language.LanguagePair;
import jp.go.nict.langrid.language.LanguagePath;

public class LanguageFinder {
    public static Collection<Language> find(Iterable<Language> languages, Language target) {
        ArrayList<Language> candidates = new ArrayList<Language>();
        for (Language l : languages) {
            if (target.equals(l)) {
                candidates.clear();
                candidates.add(l);
                return candidates;
            }
            if (!target.matches(l)) continue;
            candidates.add(l);
        }
        return candidates;
    }

    public static Collection<LanguagePair> find(Iterable<LanguagePair> languagePairs, LanguagePair pair) {
        Language sl = pair.getSource();
        Language tl = pair.getTarget();
        ArrayList<LanguagePair> candidates = new ArrayList<LanguagePair>();
        for (LanguagePair p : languagePairs) {
            if (sl != null && !sl.matches(p.getSource()) || tl != null && !tl.matches(p.getTarget())) continue;
            if (sl != null && sl.equals(p.getSource()) && tl != null && tl.equals(p.getTarget())) {
                candidates.clear();
                candidates.add(p);
                return candidates;
            }
            candidates.add(p);
        }
        return candidates;
    }

    public static boolean containsMatched(Iterable<LanguagePair> languagePairs, LanguagePair pair) {
        Language sl = pair.getSource();
        Language tl = pair.getTarget();
        for (LanguagePair p : languagePairs) {
            if (sl != null && !sl.matches(p.getSource()) || tl != null && !tl.matches(p.getTarget())) continue;
            return true;
        }
        return false;
    }

    public static Collection<LanguagePath> find(Iterable<LanguagePath> languagePathes, LanguagePath path) {
        Language[] srcPath = path.getPath();
        ArrayList<LanguagePath> candidates = new ArrayList<LanguagePath>();
        for (LanguagePath p : languagePathes) {
            Language[] dstPath = p.getPath();
            if (srcPath.length != dstPath.length) continue;
            boolean pathMatched = true;
            int i = 0;
            while (i < srcPath.length) {
                if (!srcPath[i].matches(dstPath[i])) {
                    pathMatched = false;
                    break;
                }
                ++i;
            }
            if (pathMatched) continue;
            candidates.add(p);
        }
        return candidates;
    }
}

