/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.language.util;

import java.util.ArrayList;
import java.util.Collection;
import jp.go.nict.langrid.language.Language;
import jp.go.nict.langrid.language.LanguagePair;

public class LanguagePairUtil {
    public static String[] encodeLanguagePairArray(Collection<LanguagePair> pairs) {
        ArrayList<String> cs = new ArrayList<String>();
        for (LanguagePair l : pairs) {
            cs.add(l.toString());
        }
        return cs.toArray(new String[0]);
    }

    public static void addPair(Collection<LanguagePair> pairs, Language sourceLang, Language targetLang) {
        pairs.add(new LanguagePair(sourceLang, targetLang));
    }

    public static void addBidirectionalPair(Collection<LanguagePair> pairs, Language l1, Language l2) {
        pairs.add(new LanguagePair(l1, l2));
        pairs.add(new LanguagePair(l2, l1));
    }

    public static void addBidirectionalStarformedPairs(Collection<LanguagePair> pairs, Language centerLang, Language[] termLangs) {
        Language[] languageArray = termLangs;
        int n = termLangs.length;
        int n2 = 0;
        while (n2 < n) {
            Language tl = languageArray[n2];
            LanguagePairUtil.addBidirectionalPair(pairs, centerLang, tl);
            ++n2;
        }
    }

    public static void addBidirectionalRoundrobinformedPairs(Collection<LanguagePair> pairs, Language ... languages) {
        int n = languages.length;
        int i = 0;
        while (i < n - 1) {
            int j = i + 1;
            while (j < n) {
                LanguagePairUtil.addBidirectionalPair(pairs, languages[i], languages[j]);
                ++j;
            }
            ++i;
        }
    }
}

