/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.language.util;

import jp.go.nict.langrid.language.Language;
import jp.go.nict.langrid.language.LanguagePath;

public class LanguagePathMatcher {
    public static boolean matchesPrefix(LanguagePath src, LanguagePath dst) {
        Language[] dp;
        Language[] sp = src.getPath();
        if (sp.length > (dp = dst.getPath()).length) {
            return false;
        }
        if (sp.length == 0 && dp.length != 0) {
            return false;
        }
        int i = 0;
        while (i < sp.length) {
            if (!LanguagePathMatcher.matchesInNoDirection(sp[i], dp[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean matchesSuffix(LanguagePath src, LanguagePath dst) {
        Language[] dp;
        Language[] sp = src.getPath();
        if (sp.length > (dp = dst.getPath()).length) {
            return false;
        }
        if (sp.length == 0 && dp.length != 0) {
            return false;
        }
        int d = dp.length - sp.length;
        int i = sp.length - 1;
        while (i >= 0) {
            if (!LanguagePathMatcher.matchesInNoDirection(sp[i], dp[i + d])) {
                return false;
            }
            --i;
        }
        return true;
    }

    public static boolean matchesPartial(LanguagePath src, LanguagePath dst) {
        Language[] dp;
        Language[] sp = src.getPath();
        if (sp.length > (dp = dst.getPath()).length) {
            return false;
        }
        if (sp.length == 0 && dp.length != 0) {
            return false;
        }
        int si = 0;
        int di = 0;
        while (di < dp.length) {
            if (di == dp.length) {
                return false;
            }
            if (LanguagePathMatcher.matchesInNoDirection(sp[si], dp[di])) {
                if (++si == sp.length) {
                    return true;
                }
            } else if (si != 0) {
                return false;
            }
            ++di;
        }
        return false;
    }

    public static boolean matchesComplete(LanguagePath src, LanguagePath dst) {
        Language[] dp;
        Language[] sp = src.getPath();
        if (sp.length != (dp = dst.getPath()).length) {
            return false;
        }
        int i = 0;
        while (i < sp.length) {
            if (!LanguagePathMatcher.matchesInNoDirection(sp[i], dp[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean matches(LanguagePath src, LanguagePath dst) {
        sp = src.getPath();
        if (sp.length > (dp = dst.getPath()).length) {
            return false;
        }
        if (sp.length == 1 && dp.length != 1) {
            return false;
        }
        if (sp.length == 0 || dp.length == 0) {
            return false;
        }
        if (!LanguagePathMatcher.matchesInNoDirection(sp[0], dp[0])) {
            return false;
        }
        if (!LanguagePathMatcher.matchesInNoDirection(sp[sp.length - 1], dp[dp.length - 1])) {
            return false;
        }
        di = 1;
        i = 1;
        ** GOTO lbl20
        {
            if (di == dp.length - 1) {
                return false;
            }
            do {
                if (!LanguagePathMatcher.matchesInNoDirection(sp[i], dp[di++])) continue block0;
                ++i;
lbl20:
                // 2 sources

            } while (i < sp.length - 1);
        }
        return true;
    }

    public static boolean matchesInCombination(LanguagePath src, LanguagePath dstCombination) {
        Language[] sp = src.getPath();
        Language[] dp = dstCombination.getPath();
        Language[] languageArray = sp;
        int n = sp.length;
        int n2 = 0;
        while (n2 < n) {
            Language sl = languageArray[n2];
            boolean matched = false;
            Language[] languageArray2 = dp;
            int n3 = dp.length;
            int n4 = 0;
            while (n4 < n3) {
                Language dl = languageArray2[n4];
                if (LanguagePathMatcher.matchesInNoDirection(sl, dl)) {
                    matched = true;
                    break;
                }
                ++n4;
            }
            if (!matched) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static boolean matchesInNoDirection(Language src, Language dst) {
        return src.matches(dst) || dst.matches(src);
    }
}

