/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.language.util;

import java.util.function.Function;
import jp.go.nict.langrid.commons.transformer.TransformationException;
import jp.go.nict.langrid.commons.util.ArrayUtil;
import jp.go.nict.langrid.language.InvalidLanguageTagException;
import jp.go.nict.langrid.language.Language;
import jp.go.nict.langrid.language.transformer.CodeStringToLanguageTransformer;
import jp.go.nict.langrid.language.transformer.LanguageToCodeStringTransformer;

public class LanguageUtil {
    public static String encodeLanguageArray(Language[] languages) {
        return ArrayUtil.join((String[])LanguageUtil.arrayToCodeArray(languages), (String)" ");
    }

    public static Language[] decodeLanguageArray(String value) throws InvalidLanguageTagException {
        return LanguageUtil.codeArrayToArray(value.split(" "));
    }

    public static String[] arrayToCodeArray(Language[] languages) {
        return (String[])ArrayUtil.collect((Object[])languages, String.class, (Function)((Object)new LanguageToCodeStringTransformer()));
    }

    public static Language[] codeArrayToArray(String[] languages) throws InvalidLanguageTagException {
        try {
            return (Language[])ArrayUtil.collect((Object[])languages, Language.class, (Function)((Object)new CodeStringToLanguageTransformer()));
        }
        catch (TransformationException e) {
            if (e.getCause() instanceof InvalidLanguageTagException) {
                throw (InvalidLanguageTagException)e.getCause();
            }
            throw e;
        }
    }
}

