/*
 * $Id: ISO639_1LanguageTags.java 217 2010-10-02 14:45:56Z t-nakaguchi $
 *
 * This is a program for Language Grid Core Node. This combines multiple language resources and provides composite language services.
 * Copyright (C) 2005-2008 NICT Language Grid Project.
 *
 * This program is free software: you can redistribute it and/or modify it 
 * under the terms of the GNU Lesser General Public License as published by 
 * the Free Software Foundation, either version 2.1 of the License, or (at 
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package jp.go.nict.langrid.language;

/**
 * 
 * 
 * @author $Author: t-nakaguchi $
 * @version $Revision: 217 $
 * @see <a href="http://www.loc.gov/standards/iso639-2/ISO-639-2_utf-8.txt">ISO639.2 code list</a>
 */
public class ISO639_1LanguageTags{
	/**
	 * "Afar"
	 */
	public static Language aa = Language.get(ISO639_1.AA);

	/**
	 * "Abkhazian"
	 */
	public static Language ab = Language.get(ISO639_1.AB);

	/**
	 * "Afrikaans"
	 */
	public static Language af = Language.get(ISO639_1.AF);

	/**
	 * "Akan"
	 */
	public static Language ak = Language.get(ISO639_1.AK);

	/**
	 * "Albanian"
	 */
	public static Language sq = Language.get(ISO639_1.SQ);

	/**
	 * "Amharic"
	 */
	public static Language am = Language.get(ISO639_1.AM);

	/**
	 * "Arabic"
	 */
	public static Language ar = Language.get(ISO639_1.AR);

	/**
	 * "Aragonese"
	 */
	public static Language an = Language.get(ISO639_1.AN);

	/**
	 * "Armenian"
	 */
	public static Language hy = Language.get(ISO639_1.HY);

	/**
	 * "Assamese"
	 */
	public static Language as = Language.get(ISO639_1.AS);

	/**
	 * "Avaric"
	 */
	public static Language av = Language.get(ISO639_1.AV);

	/**
	 * "Avestan"
	 */
	public static Language ae = Language.get(ISO639_1.AE);

	/**
	 * "Aymara"
	 */
	public static Language ay = Language.get(ISO639_1.AY);

	/**
	 * "Azerbaijani"
	 */
	public static Language az = Language.get(ISO639_1.AZ);

	/**
	 * "Bashkir"
	 */
	public static Language ba = Language.get(ISO639_1.BA);

	/**
	 * "Bambara"
	 */
	public static Language bm = Language.get(ISO639_1.BM);

	/**
	 * "Basque"
	 */
	public static Language eu = Language.get(ISO639_1.EU);

	/**
	 * "Belarusian"
	 */
	public static Language be = Language.get(ISO639_1.BE);

	/**
	 * "Bengali"
	 */
	public static Language bn = Language.get(ISO639_1.BN);

	/**
	 * "Bihari"
	 */
	public static Language bh = Language.get(ISO639_1.BH);

	/**
	 * "Bislama"
	 */
	public static Language bi = Language.get(ISO639_1.BI);

	/**
	 * "Bosnian"
	 */
	public static Language bs = Language.get(ISO639_1.BS);

	/**
	 * "Breton"
	 */
	public static Language br = Language.get(ISO639_1.BR);

	/**
	 * "Bulgarian"
	 */
	public static Language bg = Language.get(ISO639_1.BG);

	/**
	 * "Burmese"
	 */
	public static Language my = Language.get(ISO639_1.MY);

	/**
	 * "Catalan", "Valencian"
	 */
	public static Language ca = Language.get(ISO639_1.CA);

	/**
	 * "Chamorro"
	 */
	public static Language ch = Language.get(ISO639_1.CH);

	/**
	 * "Chechen"
	 */
	public static Language ce = Language.get(ISO639_1.CE);

	/**
	 * "Chinese"
	 */
	public static Language zh = Language.get(ISO639_1.ZH);

	/**
	 * "Church Slavic", "Old Slavonic", "Church Slavonic", "Old Bulgarian", "Old Church Slavonic"
	 */
	public static Language cu = Language.get(ISO639_1.CU);

	/**
	 * "Chuvash"
	 */
	public static Language cv = Language.get(ISO639_1.CV);

	/**
	 * "Cornish"
	 */
	public static Language kw = Language.get(ISO639_1.KW);

	/**
	 * "Corsican"
	 */
	public static Language co = Language.get(ISO639_1.CO);

	/**
	 * "Cree"
	 */
	public static Language cr = Language.get(ISO639_1.CR);

	/**
	 * "Czech"
	 */
	public static Language cs = Language.get(ISO639_1.CS);

	/**
	 * "Danish"
	 */
	public static Language da = Language.get(ISO639_1.DA);

	/**
	 * "Divehi", "Dhivehi", "Maldivian"
	 */
	public static Language dv = Language.get(ISO639_1.DV);

	/**
	 * "Dutch", "Flemish"
	 */
	public static Language nl = Language.get(ISO639_1.NL);

	/**
	 * "Dzongkha"
	 */
	public static Language dz = Language.get(ISO639_1.DZ);

	/**
	 * "English"
	 */
	public static Language en = Language.get(ISO639_1.EN);

	/**
	 * "Esperanto"
	 */
	public static Language eo = Language.get(ISO639_1.EO);

	/**
	 * "Estonian"
	 */
	public static Language et = Language.get(ISO639_1.ET);

	/**
	 * "Ewe"
	 */
	public static Language ee = Language.get(ISO639_1.EE);

	/**
	 * "Faroese"
	 */
	public static Language fo = Language.get(ISO639_1.FO);

	/**
	 * "Fijian"
	 */
	public static Language fj = Language.get(ISO639_1.FJ);

	/**
	 * "Finnish"
	 */
	public static Language fi = Language.get(ISO639_1.FI);

	/**
	 * "French"
	 */
	public static Language fr = Language.get(ISO639_1.FR);

	/**
	 * "Western Frisian"
	 */
	public static Language fy = Language.get(ISO639_1.FY);

	/**
	 * "Fulah"
	 */
	public static Language ff = Language.get(ISO639_1.FF);

	/**
	 * "Georgian"
	 */
	public static Language ka = Language.get(ISO639_1.KA);

	/**
	 * "German"
	 */
	public static Language de = Language.get(ISO639_1.DE);

	/**
	 * "Gaelic", "Scottish Gaelic"
	 */
	public static Language gd = Language.get(ISO639_1.GD);

	/**
	 * "Irish"
	 */
	public static Language ga = Language.get(ISO639_1.GA);

	/**
	 * "Galician"
	 */
	public static Language gl = Language.get(ISO639_1.GL);

	/**
	 * "Manx"
	 */
	public static Language gv = Language.get(ISO639_1.GV);

	/**
	 * "Greek, Modern (1453-)"
	 */
	public static Language el = Language.get(ISO639_1.EL);

	/**
	 * "Guarani"
	 */
	public static Language gn = Language.get(ISO639_1.GN);

	/**
	 * "Gujarati"
	 */
	public static Language gu = Language.get(ISO639_1.GU);

	/**
	 * "Haitian", "Haitian Creole"
	 */
	public static Language ht = Language.get(ISO639_1.HT);

	/**
	 * "Hausa"
	 */
	public static Language ha = Language.get(ISO639_1.HA);

	/**
	 * "Hebrew"
	 */
	public static Language he = Language.get(ISO639_1.HE);

	/**
	 * "Herero"
	 */
	public static Language hz = Language.get(ISO639_1.HZ);

	/**
	 * "Hindi"
	 */
	public static Language hi = Language.get(ISO639_1.HI);

	/**
	 * "Hiri Motu"
	 */
	public static Language ho = Language.get(ISO639_1.HO);

	/**
	 * "Croatian"
	 */
	public static Language hr = Language.get(ISO639_1.HR);

	/**
	 * "Hungarian"
	 */
	public static Language hu = Language.get(ISO639_1.HU);

	/**
	 * "Igbo"
	 */
	public static Language ig = Language.get(ISO639_1.IG);

	/**
	 * "Icelandic"
	 */
	public static Language is = Language.get(ISO639_1.IS);

	/**
	 * "Ido"
	 */
	public static Language io = Language.get(ISO639_1.IO);

	/**
	 * "Sichuan Yi", "Nuosu"
	 */
	public static Language ii = Language.get(ISO639_1.II);

	/**
	 * "Inuktitut"
	 */
	public static Language iu = Language.get(ISO639_1.IU);

	/**
	 * "Interlingue", "Occidental"
	 */
	public static Language ie = Language.get(ISO639_1.IE);

	/**
	 * "Interlingua (International Auxiliary Language Association)"
	 */
	public static Language ia = Language.get(ISO639_1.IA);

	/**
	 * "Indonesian"
	 */
	public static Language id = Language.get(ISO639_1.ID);

	/**
	 * "Inupiaq"
	 */
	public static Language ik = Language.get(ISO639_1.IK);

	/**
	 * "Italian"
	 */
	public static Language it = Language.get(ISO639_1.IT);

	/**
	 * "Javanese"
	 */
	public static Language jv = Language.get(ISO639_1.JV);

	/**
	 * "Japanese"
	 */
	public static Language ja = Language.get(ISO639_1.JA);

	/**
	 * "Kalaallisut", "Greenlandic"
	 */
	public static Language kl = Language.get(ISO639_1.KL);

	/**
	 * "Kannada"
	 */
	public static Language kn = Language.get(ISO639_1.KN);

	/**
	 * "Kashmiri"
	 */
	public static Language ks = Language.get(ISO639_1.KS);

	/**
	 * "Kanuri"
	 */
	public static Language kr = Language.get(ISO639_1.KR);

	/**
	 * "Kazakh"
	 */
	public static Language kk = Language.get(ISO639_1.KK);

	/**
	 * "Central Khmer"
	 */
	public static Language km = Language.get(ISO639_1.KM);

	/**
	 * "Kikuyu", "Gikuyu"
	 */
	public static Language ki = Language.get(ISO639_1.KI);

	/**
	 * "Kinyarwanda"
	 */
	public static Language rw = Language.get(ISO639_1.RW);

	/**
	 * "Kirghiz", "Kyrgyz"
	 */
	public static Language ky = Language.get(ISO639_1.KY);

	/**
	 * "Komi"
	 */
	public static Language kv = Language.get(ISO639_1.KV);

	/**
	 * "Kongo"
	 */
	public static Language kg = Language.get(ISO639_1.KG);

	/**
	 * "Korean"
	 */
	public static Language ko = Language.get(ISO639_1.KO);

	/**
	 * "Kuanyama", "Kwanyama"
	 */
	public static Language kj = Language.get(ISO639_1.KJ);

	/**
	 * "Kurdish"
	 */
	public static Language ku = Language.get(ISO639_1.KU);

	/**
	 * "Lao"
	 */
	public static Language lo = Language.get(ISO639_1.LO);

	/**
	 * "Latin"
	 */
	public static Language la = Language.get(ISO639_1.LA);

	/**
	 * "Latvian"
	 */
	public static Language lv = Language.get(ISO639_1.LV);

	/**
	 * "Limburgan", "Limburger", "Limburgish"
	 */
	public static Language li = Language.get(ISO639_1.LI);

	/**
	 * "Lingala"
	 */
	public static Language ln = Language.get(ISO639_1.LN);

	/**
	 * "Lithuanian"
	 */
	public static Language lt = Language.get(ISO639_1.LT);

	/**
	 * "Luxembourgish", "Letzeburgesch"
	 */
	public static Language lb = Language.get(ISO639_1.LB);

	/**
	 * "Luba-Katanga"
	 */
	public static Language lu = Language.get(ISO639_1.LU);

	/**
	 * "Ganda"
	 */
	public static Language lg = Language.get(ISO639_1.LG);

	/**
	 * "Macedonian"
	 */
	public static Language mk = Language.get(ISO639_1.MK);

	/**
	 * "Marshallese"
	 */
	public static Language mh = Language.get(ISO639_1.MH);

	/**
	 * "Malayalam"
	 */
	public static Language ml = Language.get(ISO639_1.ML);

	/**
	 * "Maori"
	 */
	public static Language mi = Language.get(ISO639_1.MI);

	/**
	 * "Marathi"
	 */
	public static Language mr = Language.get(ISO639_1.MR);

	/**
	 * "Malay"
	 */
	public static Language ms = Language.get(ISO639_1.MS);

	/**
	 * "Malagasy"
	 */
	public static Language mg = Language.get(ISO639_1.MG);

	/**
	 * "Maltese"
	 */
	public static Language mt = Language.get(ISO639_1.MT);

	/**
	 * "Mongolian"
	 */
	public static Language mn = Language.get(ISO639_1.MN);

	/**
	 * "Nauru"
	 */
	public static Language na = Language.get(ISO639_1.NA);

	/**
	 * "Navajo", "Navaho"
	 */
	public static Language nv = Language.get(ISO639_1.NV);

	/**
	 * "Ndebele, South", "South Ndebele"
	 */
	public static Language nr = Language.get(ISO639_1.NR);

	/**
	 * "Ndebele, North", "North Ndebele"
	 */
	public static Language nd = Language.get(ISO639_1.ND);

	/**
	 * "Ndonga"
	 */
	public static Language ng = Language.get(ISO639_1.NG);

	/**
	 * "Nepali"
	 */
	public static Language ne = Language.get(ISO639_1.NE);

	/**
	 * "Norwegian Nynorsk", "Nynorsk, Norwegian"
	 */
	public static Language nn = Language.get(ISO639_1.NN);

	/**
	 * "Bokmål, Norwegian", "Norwegian Bokmål"
	 */
	public static Language nb = Language.get(ISO639_1.NB);

	/**
	 * "Norwegian"
	 */
	public static Language no = Language.get(ISO639_1.NO);

	/**
	 * "Chichewa", "Chewa", "Nyanja"
	 */
	public static Language ny = Language.get(ISO639_1.NY);

	/**
	 * "Occitan (post 1500)", "Provençal"
	 */
	public static Language oc = Language.get(ISO639_1.OC);

	/**
	 * "Ojibwa"
	 */
	public static Language oj = Language.get(ISO639_1.OJ);

	/**
	 * "Oriya"
	 */
	public static Language or = Language.get(ISO639_1.OR);

	/**
	 * "Oromo"
	 */
	public static Language om = Language.get(ISO639_1.OM);

	/**
	 * "Ossetian", "Ossetic"
	 */
	public static Language os = Language.get(ISO639_1.OS);

	/**
	 * "Panjabi", "Punjabi"
	 */
	public static Language pa = Language.get(ISO639_1.PA);

	/**
	 * "Persian"
	 */
	public static Language fa = Language.get(ISO639_1.FA);

	/**
	 * "Pali"
	 */
	public static Language pi = Language.get(ISO639_1.PI);

	/**
	 * "Polish"
	 */
	public static Language pl = Language.get(ISO639_1.PL);

	/**
	 * "Portuguese"
	 */
	public static Language pt = Language.get(ISO639_1.PT);

	/**
	 * "Pushto", "Pashto"
	 */
	public static Language ps = Language.get(ISO639_1.PS);

	/**
	 * "Quechua"
	 */
	public static Language qu = Language.get(ISO639_1.QU);

	/**
	 * "Romansh"
	 */
	public static Language rm = Language.get(ISO639_1.RM);

	/**
	 * "Romanian", "Moldavian", "Moldovan"
	 */
	public static Language ro = Language.get(ISO639_1.RO);

	/**
	 * "Rundi"
	 */
	public static Language rn = Language.get(ISO639_1.RN);

	/**
	 * "Russian"
	 */
	public static Language ru = Language.get(ISO639_1.RU);

	/**
	 * "Sango"
	 */
	public static Language sg = Language.get(ISO639_1.SG);

	/**
	 * "Sanskrit"
	 */
	public static Language sa = Language.get(ISO639_1.SA);

	/**
	 * "Sinhala", "Sinhalese"
	 */
	public static Language si = Language.get(ISO639_1.SI);

	/**
	 * "Slovak"
	 */
	public static Language sk = Language.get(ISO639_1.SK);

	/**
	 * "Slovenian"
	 */
	public static Language sl = Language.get(ISO639_1.SL);

	/**
	 * "Northern Sami"
	 */
	public static Language se = Language.get(ISO639_1.SE);

	/**
	 * "Samoan"
	 */
	public static Language sm = Language.get(ISO639_1.SM);

	/**
	 * "Shona"
	 */
	public static Language sn = Language.get(ISO639_1.SN);

	/**
	 * "Sindhi"
	 */
	public static Language sd = Language.get(ISO639_1.SD);

	/**
	 * "Somali"
	 */
	public static Language so = Language.get(ISO639_1.SO);

	/**
	 * "Sotho, Southern"
	 */
	public static Language st = Language.get(ISO639_1.ST);

	/**
	 * "Spanish", "Castilian"
	 */
	public static Language es = Language.get(ISO639_1.ES);

	/**
	 * "Sardinian"
	 */
	public static Language sc = Language.get(ISO639_1.SC);

	/**
	 * "Serbian"
	 */
	public static Language sr = Language.get(ISO639_1.SR);

	/**
	 * "Swati"
	 */
	public static Language ss = Language.get(ISO639_1.SS);

	/**
	 * "Sundanese"
	 */
	public static Language su = Language.get(ISO639_1.SU);

	/**
	 * "Swahili"
	 */
	public static Language sw = Language.get(ISO639_1.SW);

	/**
	 * "Swedish"
	 */
	public static Language sv = Language.get(ISO639_1.SV);

	/**
	 * "Tahitian"
	 */
	public static Language ty = Language.get(ISO639_1.TY);

	/**
	 * "Tamil"
	 */
	public static Language ta = Language.get(ISO639_1.TA);

	/**
	 * "Tatar"
	 */
	public static Language tt = Language.get(ISO639_1.TT);

	/**
	 * "Telugu"
	 */
	public static Language te = Language.get(ISO639_1.TE);

	/**
	 * "Tajik"
	 */
	public static Language tg = Language.get(ISO639_1.TG);

	/**
	 * "Tagalog"
	 */
	public static Language tl = Language.get(ISO639_1.TL);

	/**
	 * "Thai"
	 */
	public static Language th = Language.get(ISO639_1.TH);

	/**
	 * "Tibetan"
	 */
	public static Language bo = Language.get(ISO639_1.BO);

	/**
	 * "Tigrinya"
	 */
	public static Language ti = Language.get(ISO639_1.TI);

	/**
	 * "Tonga (Tonga Islands)"
	 */
	public static Language to = Language.get(ISO639_1.TO);

	/**
	 * "Tswana"
	 */
	public static Language tn = Language.get(ISO639_1.TN);

	/**
	 * "Tsonga"
	 */
	public static Language ts = Language.get(ISO639_1.TS);

	/**
	 * "Turkmen"
	 */
	public static Language tk = Language.get(ISO639_1.TK);

	/**
	 * "Turkish"
	 */
	public static Language tr = Language.get(ISO639_1.TR);

	/**
	 * "Twi"
	 */
	public static Language tw = Language.get(ISO639_1.TW);

	/**
	 * "Uighur", "Uyghur"
	 */
	public static Language ug = Language.get(ISO639_1.UG);

	/**
	 * "Ukrainian"
	 */
	public static Language uk = Language.get(ISO639_1.UK);

	/**
	 * "Urdu"
	 */
	public static Language ur = Language.get(ISO639_1.UR);

	/**
	 * "Uzbek"
	 */
	public static Language uz = Language.get(ISO639_1.UZ);

	/**
	 * "Venda"
	 */
	public static Language ve = Language.get(ISO639_1.VE);

	/**
	 * "Vietnamese"
	 */
	public static Language vi = Language.get(ISO639_1.VI);

	/**
	 * "Volapük"
	 */
	public static Language vo = Language.get(ISO639_1.VO);

	/**
	 * "Welsh"
	 */
	public static Language cy = Language.get(ISO639_1.CY);

	/**
	 * "Walloon"
	 */
	public static Language wa = Language.get(ISO639_1.WA);

	/**
	 * "Wolof"
	 */
	public static Language wo = Language.get(ISO639_1.WO);

	/**
	 * "Xhosa"
	 */
	public static Language xh = Language.get(ISO639_1.XH);

	/**
	 * "Yiddish"
	 */
	public static Language yi = Language.get(ISO639_1.YI);

	/**
	 * "Yoruba"
	 */
	public static Language yo = Language.get(ISO639_1.YO);

	/**
	 * "Zhuang", "Chuang"
	 */
	public static Language za = Language.get(ISO639_1.ZA);

	/**
	 * "Zulu"
	 */
	public static Language zu = Language.get(ISO639_1.ZU);

	/**
	 * "Moldavian"
	 */
	public static Language mo = Language.get(ISO639_1.MO);

	/**
	 * "Serbo-Croatian"
	 */
	public static Language sh = Language.get(ISO639_1.SH);


}
