/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.language.transformer;

import jp.go.nict.langrid.commons.transformer.TransformationException;
import jp.go.nict.langrid.commons.transformer.Transformer;
import jp.go.nict.langrid.language.InvalidLanguageTagException;
import jp.go.nict.langrid.language.Language;
import jp.go.nict.langrid.language.LanguagePair;
import jp.go.nict.langrid.language.util.LanguageUtil;

public class CodeStringToLanguagePairTransformer
implements Transformer<String, LanguagePair> {
    public LanguagePair transform(String value) throws TransformationException {
        if (value == null) {
            return null;
        }
        try {
            Language[] langs = LanguageUtil.decodeLanguageArray(value);
            if (langs.length != 2) {
                throw new TransformationException(String.format("length of languages must be 2: \"%s\"", value));
            }
            return new LanguagePair(langs[0], langs[1]);
        }
        catch (InvalidLanguageTagException e) {
            throw new TransformationException((Throwable)e);
        }
    }
}

