/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.language.util;

import java.text.ParseException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import java.util.function.Function;
import jp.go.nict.langrid.commons.lang.StringUtil;
import jp.go.nict.langrid.commons.transformer.TransformationException;
import jp.go.nict.langrid.commons.transformer.Transformer;
import jp.go.nict.langrid.commons.util.ArrayUtil;
import jp.go.nict.langrid.language.InvalidLanguagePathException;
import jp.go.nict.langrid.language.InvalidLanguageTagException;
import jp.go.nict.langrid.language.Language;
import jp.go.nict.langrid.language.LanguagePair;
import jp.go.nict.langrid.language.LanguagePath;
import jp.go.nict.langrid.language.transformer.CodeStringToLanguagePathTransformer;
import jp.go.nict.langrid.language.transformer.LanguageToCodeStringTransformer;
import jp.go.nict.langrid.language.transformer.LanguageToLocalizedNameTransformer;
import jp.go.nict.langrid.language.util.LanguageUtil;

public class LanguagePathUtil {
    public static String joinCodes(LanguagePath path, String separator) {
        return StringUtil.join((Object[])path.getPath(), (Function)((Object)new LanguageToCodeStringTransformer()), (String)separator);
    }

    public static Set<LanguagePair> createSourceTargetPairSet(LanguagePath[] paths) {
        LanguagePath[] langs = paths;
        HashSet<LanguagePair> pairs = new HashSet<LanguagePair>();
        for (LanguagePath p : langs) {
            pairs.add(p.createSourceTargetPair());
        }
        return pairs;
    }

    public static void addBidirectionalStarformedPairs(Collection<LanguagePair> pairs, Language centerLang, Language[] termLangs) {
        for (Language tl : termLangs) {
            pairs.add(new LanguagePair(centerLang, tl));
            pairs.add(new LanguagePair(tl, centerLang));
        }
    }

    public static String encodeLanguagePath(LanguagePath value) {
        return LanguageUtil.encodeLanguageArray(value.getPath());
    }

    public static LanguagePath decodeLanguagePath(String value) throws InvalidLanguageTagException, InvalidLanguagePathException {
        if (value.startsWith("(")) {
            value = value.substring(1);
        }
        if (value.endsWith(")")) {
            value = value.substring(0, value.length() - 1);
        }
        return new LanguagePath(LanguageUtil.decodeLanguageArray(value));
    }

    public static String encodeLanguagePathArray(LanguagePath ... value) {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        for (LanguagePath path : value) {
            boolean first = true;
            builder.append("(");
            for (Language language : path.getPath()) {
                if (!first) {
                    builder.append(" ");
                } else {
                    first = false;
                }
                builder.append(language.getCode());
            }
            builder.append(")");
        }
        builder.append(")");
        return builder.toString();
    }

    public static LanguagePath[] decodeLanguagePathArray(String line) throws InvalidLanguageTagException, InvalidLanguagePathException {
        Object[] codeTuples = null;
        try {
            codeTuples = StringUtil.decodeTuple((String)line);
        }
        catch (ParseException e) {
            throw new InvalidLanguagePathException(e);
        }
        try {
            return (LanguagePath[])ArrayUtil.collect((Object[])codeTuples, (Function)((Object)new CodeStringToLanguagePathTransformer()));
        }
        catch (TransformationException e) {
            throw new InvalidLanguagePathException(e);
        }
    }

    public static String encodeToSimplifiedExpressionByCode(LanguagePath[] paths) {
        return LanguagePathUtil.encodeToSimplefiedExpression(paths, new LanguageToCodeStringTransformer(), "), (");
    }

    public static String encodeToSimplifiedExpressionByName(LanguagePath[] paths, Locale locale) {
        return LanguagePathUtil.encodeToSimplefiedExpression(paths, new LanguageToLocalizedNameTransformer(locale), "), (");
    }

    private static String encodeToSimplefiedExpression(LanguagePath[] paths, Transformer<Language, String> textizer, String separator) {
        boolean first = true;
        StringBuilder b = new StringBuilder();
        b.append("(");
        LinkedHashSet<LanguagePath> pathset = new LinkedHashSet<LanguagePath>();
        for (LanguagePath p : paths) {
            pathset.add(p);
        }
        Iterator i = pathset.iterator();
        while (i.hasNext()) {
            LanguagePath p = (LanguagePath)i.next();
            i.remove();
            if (first) {
                first = false;
            } else {
                b.append(separator);
            }
            if (p.getPath().length == 1) {
                b.append((String)textizer.transform((Object)p.getPath()[0]));
                continue;
            }
            if (p.getPath().length == 2) {
                LanguagePath r = p.reverse();
                if (pathset.contains(r)) {
                    pathset.remove(r);
                    i = pathset.iterator();
                    b.append(StringUtil.join((Object[])p.getPath(), textizer, (String)"<->"));
                    continue;
                }
                Object[] path = p.getPath();
                b.append(StringUtil.join((Object[])path, textizer, (String)"-", (int)0, (int)(path.length - 1)));
                b.append("->");
                b.append((String)textizer.transform(path[path.length - 1]));
                continue;
            }
            Object[] path = p.getPath();
            b.append(StringUtil.join((Object[])path, textizer, (String)"-", (int)0, (int)(path.length - 1)));
            b.append("->");
            b.append((String)textizer.transform(path[path.length - 1]));
        }
        b.append(")");
        return b.toString();
    }
}

