/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.language.util;

import jp.go.nict.langrid.language.Language;
import jp.go.nict.langrid.language.LanguagePath;

public class LanguagePathMatcher {
    public static boolean matchesPrefix(LanguagePath src, LanguagePath dst) {
        Language[] dp;
        Language[] sp = src.getPath();
        if (sp.length > (dp = dst.getPath()).length) {
            return false;
        }
        if (sp.length == 0 && dp.length != 0) {
            return false;
        }
        for (int i = 0; i < sp.length; ++i) {
            if (LanguagePathMatcher.matchesInNoDirection(sp[i], dp[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean matchesSuffix(LanguagePath src, LanguagePath dst) {
        Language[] dp;
        Language[] sp = src.getPath();
        if (sp.length > (dp = dst.getPath()).length) {
            return false;
        }
        if (sp.length == 0 && dp.length != 0) {
            return false;
        }
        int d = dp.length - sp.length;
        for (int i = sp.length - 1; i >= 0; --i) {
            if (LanguagePathMatcher.matchesInNoDirection(sp[i], dp[i + d])) continue;
            return false;
        }
        return true;
    }

    public static boolean matchesPartial(LanguagePath src, LanguagePath dst) {
        Language[] dp;
        Language[] sp = src.getPath();
        if (sp.length > (dp = dst.getPath()).length) {
            return false;
        }
        if (sp.length == 0 && dp.length != 0) {
            return false;
        }
        int si = 0;
        for (int di = 0; di < dp.length; ++di) {
            if (di == dp.length) {
                return false;
            }
            if (LanguagePathMatcher.matchesInNoDirection(sp[si], dp[di])) {
                if (++si != sp.length) continue;
                return true;
            }
            if (si == 0) continue;
            return false;
        }
        return false;
    }

    public static boolean matchesComplete(LanguagePath src, LanguagePath dst) {
        Language[] dp;
        Language[] sp = src.getPath();
        if (sp.length != (dp = dst.getPath()).length) {
            return false;
        }
        for (int i = 0; i < sp.length; ++i) {
            if (LanguagePathMatcher.matchesInNoDirection(sp[i], dp[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean matches(LanguagePath src, LanguagePath dst) {
        Language[] dp;
        Language[] sp = src.getPath();
        if (sp.length > (dp = dst.getPath()).length) {
            return false;
        }
        if (sp.length == 1 && dp.length != 1) {
            return false;
        }
        if (sp.length == 0 || dp.length == 0) {
            return false;
        }
        if (!LanguagePathMatcher.matchesInNoDirection(sp[0], dp[0])) {
            return false;
        }
        if (!LanguagePathMatcher.matchesInNoDirection(sp[sp.length - 1], dp[dp.length - 1])) {
            return false;
        }
        int di = 1;
        for (int i = 1; i < sp.length - 1; ++i) {
            while (!LanguagePathMatcher.matchesInNoDirection(sp[i], dp[di++])) {
                if (di != dp.length - 1) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean matchesInCombination(LanguagePath src, LanguagePath dstCombination) {
        Language[] sp = src.getPath();
        Language[] dp = dstCombination.getPath();
        for (Language sl : sp) {
            boolean matched = false;
            for (Language dl : dp) {
                if (!LanguagePathMatcher.matchesInNoDirection(sl, dl)) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            return false;
        }
        return true;
    }

    private static boolean matchesInNoDirection(Language src, Language dst) {
        return src.matches(dst) || dst.matches(src);
    }
}

