/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.LanguageMaintainedState;
import org.languagetool.UserConfig;
import org.languagetool.language.AlgerianArabic;
import org.languagetool.language.Contributor;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.GenericUnpairedBracketsRule;
import org.languagetool.rules.LongSentenceRule;
import org.languagetool.rules.MultipleWhitespaceRule;
import org.languagetool.rules.Rule;
import org.languagetool.rules.SentenceWhitespaceRule;
import org.languagetool.rules.ar.ArabicCommaWhitespaceRule;
import org.languagetool.rules.ar.ArabicConfusionProbabilityRule;
import org.languagetool.rules.ar.ArabicDoublePunctuationRule;
import org.languagetool.rules.ar.ArabicHunspellSpellerRule;
import org.languagetool.rules.ar.ArabicSimpleReplaceRule;
import org.languagetool.rules.ar.ArabicWordRepeatRule;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.synthesis.ar.ArabicSynthesizer;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.ar.ArabicHybridDisambiguator;
import org.languagetool.tagging.ar.ArabicTagger;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tokenizers.ArabicWordTokenizer;
import org.languagetool.tokenizers.SRXSentenceTokenizer;
import org.languagetool.tokenizers.SentenceTokenizer;
import org.languagetool.tokenizers.WordTokenizer;

public class Arabic
extends Language
implements AutoCloseable {
    private static final Language DEFAULT_ARABIC = new AlgerianArabic();
    private SentenceTokenizer sentenceTokenizer;
    private WordTokenizer wordTokenizer;
    private Tagger tagger;
    private Synthesizer synthesizer;
    private LanguageModel languageModel;
    private Disambiguator disambiguator;

    public String getName() {
        return "Arabic";
    }

    public String getShortCode() {
        return "ar";
    }

    public String[] getCountries() {
        return new String[]{"", "SA", "DZ", "BH", "EG", "IQ", "JO", "KW", "LB", "LY", "MA", "OM", "QA", "SD", "SY", "TN", "AE", "YE"};
    }

    public Language getDefaultLanguageVariant() {
        return DEFAULT_ARABIC;
    }

    public Disambiguator getDisambiguator() {
        if (this.disambiguator == null) {
            this.disambiguator = new ArabicHybridDisambiguator();
        }
        return this.disambiguator;
    }

    public SentenceTokenizer getSentenceTokenizer() {
        if (this.sentenceTokenizer == null) {
            this.sentenceTokenizer = new SRXSentenceTokenizer((Language)this);
        }
        return this.sentenceTokenizer;
    }

    public WordTokenizer getWordTokenizer() {
        if (this.wordTokenizer == null) {
            this.wordTokenizer = new ArabicWordTokenizer();
        }
        return this.wordTokenizer;
    }

    public Tagger getTagger() {
        if (this.tagger == null) {
            this.tagger = new ArabicTagger();
        }
        return this.tagger;
    }

    public Synthesizer getSynthesizer() {
        if (this.synthesizer == null) {
            this.synthesizer = new ArabicSynthesizer(this);
        }
        return this.synthesizer;
    }

    public Contributor[] getMaintainers() {
        return new Contributor[]{new Contributor("Taha Zerrouki"), new Contributor("Sohaib Afifi"), new Contributor("Imen Kali"), new Contributor("Karima Tchoketch")};
    }

    public List<Rule> getRelevantRules(ResourceBundle messages, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) throws IOException {
        return Arrays.asList(new Rule[]{new MultipleWhitespaceRule(messages, (Language)this), new SentenceWhitespaceRule(messages), new GenericUnpairedBracketsRule(messages, Arrays.asList("[", "(", "{", "\u00ab", "\ufd3e", "\"", "'"), Arrays.asList("]", ")", "}", "\u00bb", "\ufd3f", "\"", "'")), new ArabicHunspellSpellerRule(messages, this, userConfig, altLanguages), new ArabicCommaWhitespaceRule(messages), new ArabicDoublePunctuationRule(messages), new LongSentenceRule(messages, userConfig, -1, false), new ArabicWordRepeatRule(messages, this), new ArabicSimpleReplaceRule(messages, this)});
    }

    public List<Rule> getRelevantLanguageModelRules(ResourceBundle messages, LanguageModel languageModel, UserConfig userConfig) throws IOException {
        return Arrays.asList(new Rule[]{new ArabicConfusionProbabilityRule(messages, languageModel, this)});
    }

    public LanguageMaintainedState getMaintainedState() {
        return LanguageMaintainedState.ActivelyMaintained;
    }

    public synchronized LanguageModel getLanguageModel(File indexDir) throws IOException {
        this.languageModel = this.initLanguageModel(indexDir, this.languageModel);
        return this.languageModel;
    }

    @Override
    public void close() throws Exception {
        if (this.languageModel != null) {
            this.languageModel.close();
        }
    }
}

