/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ar;

import java.util.Locale;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.rules.AbstractSimpleReplaceRule2;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;

public class ArabicSimpleReplaceRule
extends AbstractSimpleReplaceRule2 {
    public static final String RULE_ID = "AR_SIMPLE_REPLACE";
    private static final String RESOURCE_FILENAME = "ar/replaces.txt";

    public ArabicSimpleReplaceRule(ResourceBundle messages, Language language) {
        super(messages, language);
        super.setCategory(Categories.CONFUSED_WORDS.getCategory(messages));
        this.addExamplePair(Example.wrong((String)"<marker>\u0625\u0646\u0634\u0627\u0621</marker>"), Example.fixed((String)"<marker>\u0625\u0646 \u0634\u0627\u0621</marker>"));
    }

    public String getFileName() {
        return RESOURCE_FILENAME;
    }

    public String getId() {
        return RULE_ID;
    }

    public String getDescription() {
        return "A rule that matches words which should not be used and suggests correct ones instead";
    }

    public String getShort() {
        return "\u062e\u0637\u0623 \u0625\u0645\u0644\u0627\u0626\u064a";
    }

    public boolean isDictionaryBasedSpellingRule() {
        return false;
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public String getSuggestion() {
        return "\u0642\u0644 $suggestions";
    }

    public String getSuggestionsSeparator() {
        return " \u0623\u0648  ";
    }

    public Locale getLocale() {
        return new Locale("ar");
    }
}

