/* LanguageTool, a natural language style checker
 * Copyright (C) 2022 Sohaib Afifi, Taha Zerrouki
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

package org.languagetool.rules.ar.filters;


import org.languagetool.language.Arabic;
import org.languagetool.rules.AbstractAdvancedSynthesizerFilter;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.synthesis.ar.ArabicSynthesizer;

/*
 * Synthesize suggestions using the lemma from one token (lemma_from)
 * and the POS tag from another one (postag_from).
 *
 * The lemma_select and postag_select attributes are required
 * to choose one among several possible readings.
 */
public class ArabicAdvancedSynthesizerFilter extends AbstractAdvancedSynthesizerFilter {

  private final ArabicSynthesizer synth = new ArabicSynthesizer(new Arabic());

  @Override
  protected Synthesizer getSynthesizer() {
    return synth;
  }

}
