/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ar;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.language.Arabic;
import org.languagetool.rules.AbstractSimpleReplaceRule2;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;

public class ArabicDiacriticsRule
extends AbstractSimpleReplaceRule2 {
    public static final String AR_DIACRITICS_REPLACE = "AR_DIACRITICS_REPLACE";
    private static final String FILE_NAME = "/ar/diacritics.txt";
    private static final Locale AR_LOCALE = new Locale("ar");

    public ArabicDiacriticsRule(ResourceBundle messages) {
        super(messages, (Language)new Arabic());
        this.setCategory(Categories.STYLE.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Style);
        this.addExamplePair(Example.wrong((String)"<marker>\u062a\u062c\u0631\u0628\u0629</marker>"), Example.fixed((String)"<marker>\u062a\u062c\u0631\u0650\u0650\u0628\u0629</marker>"));
    }

    public final List<String> getFileNames() {
        return Collections.singletonList(FILE_NAME);
    }

    public final String getId() {
        return AR_DIACRITICS_REPLACE;
    }

    public String getDescription() {
        return "\u0643\u0644\u0645\u0627\u062a \u0645\u0634\u0643\u0648\u0644\u0629 \u0644\u0644\u062a\u0648\u0636\u064a\u062d";
    }

    public String getShort() {
        return "\u0643\u0644\u0645\u0627\u062a \u064a\u0633\u062a\u062d\u0633\u0646 \u0623\u0646 \u062a\u0634\u0643\u0651\u0644 \u0644\u062a\u0635\u062d\u064a\u062d \u0646\u0637\u0642\u0647\u0627";
    }

    public String getMessage() {
        return "'$match' \u0643\u0644\u0645\u0629 \u064a\u0634\u064a\u0639 \u0646\u0637\u0642\u0647\u0627 \u0646\u0637\u0642\u0627 \u062e\u0627\u0637\u0626\u0627 \u0644\u0630\u0627 \u0646\u0642\u062a\u0631\u062d \u062a\u0634\u0643\u064a\u0644\u0647\u0627 \u0643\u0627\u0644\u0622\u062a\u064a: $suggestions";
    }

    public String getSuggestionsSeparator() {
        return " \u0623\u0648 ";
    }

    public Locale getLocale() {
        return AR_LOCALE;
    }
}

