/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ar;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.language.Arabic;
import org.languagetool.rules.AbstractSimpleReplaceRule2;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.SuggestionWithMessage;
import org.languagetool.synthesis.ar.ArabicSynthesizer;
import org.languagetool.tagging.ar.ArabicTagManager;
import org.languagetool.tagging.ar.ArabicTagger;

public class ArabicTransVerbRule
extends AbstractSimpleReplaceRule2 {
    public static final String AR_VERB_TRANS_INDIRECT_REPLACE = "AR_VERB_TRANSITIVE_IINDIRECT";
    private static final String FILE_NAME = "/ar/verb_trans_to_untrans2.txt";
    private static final Locale AR_LOCALE = new Locale("ar");
    private final ArabicTagger tagger = new ArabicTagger();
    private final ArabicTagManager tagmanager;
    private final List<Map<String, SuggestionWithMessage>> wrongWords;

    public ArabicTransVerbRule(ResourceBundle messages) {
        super(messages, (Language)new Arabic());
        this.tagger.enableNewStylePronounTag();
        this.tagmanager = new ArabicTagManager();
        super.setCategory(Categories.MISC.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Misspelling);
        this.addExamplePair(Example.wrong((String)"The train arrived <marker>a hour</marker> ago."), Example.fixed((String)"The train arrived <marker>an hour</marker> ago."));
        this.wrongWords = this.getWrongWords();
    }

    public String getId() {
        return AR_VERB_TRANS_INDIRECT_REPLACE;
    }

    public String getDescription() {
        return "\u064eTransitive verbs corrected to indirect transitive";
    }

    public final List<String> getFileNames() {
        return Collections.singletonList(FILE_NAME);
    }

    public String getShort() {
        return "\u0623\u0641\u0639\u0627\u0644 \u0645\u062a\u0639\u062f\u064a\u0629 \u0628\u062d\u0631\u0641\u060c \u064a\u062e\u0637\u0626 \u0641\u064a \u062a\u0639\u062f\u064a\u062a\u0647\u0627";
    }

    public String getMessage() {
        return "'$match' \u0627\u0644\u0641\u0639\u0644 \u062e\u0627\u0637\u0626 \u0641\u064a \u0627\u0644\u062a\u0639\u062f\u064a\u0629 \u0628\u062d\u0631\u0641: $suggestions";
    }

    public String getSuggestionsSeparator() {
        return " \u0623\u0648 ";
    }

    public Locale getLocale() {
        return AR_LOCALE;
    }

    public RuleMatch[] match(AnalyzedSentence sentence) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        if (this.wrongWords.size() == 0) {
            return this.toRuleMatchArray(ruleMatches);
        }
        AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
        int prevTokenIndex = 0;
        for (int i = 1; i < tokens.length; ++i) {
            String prevTokenStr;
            AnalyzedTokenReadings token = tokens[i];
            AnalyzedTokenReadings prevToken = prevTokenIndex > 0 ? tokens[prevTokenIndex] : null;
            String string = prevTokenStr = prevTokenIndex > 0 ? tokens[prevTokenIndex].getToken() : null;
            if (prevTokenStr != null) {
                boolean is_attached_verb_transitive = this.isAttachedTransitiveVerb(prevToken);
                List<String> prepositions = this.getProperPrepositionForTransitiveVerb(prevToken);
                boolean is_right_preposition = ArabicTransVerbRule.isRightPreposition(token, prepositions);
                if (is_attached_verb_transitive && !is_right_preposition) {
                    String verb = this.getCorrectVerbForm(tokens[prevTokenIndex]);
                    String newPreposition = prepositions.get(0);
                    String preposition = this.getCorrectPrepositionForm(newPreposition, prevToken);
                    String replacement = verb + " " + preposition;
                    String msg = "\u0642\u0644 <suggestion>" + replacement + "</suggestion> \u0628\u062f\u0644\u0627 \u0645\u0646 '" + prevTokenStr + "' \u0644\u0623\u0646\u0651 \u0627\u0644\u0641\u0639\u0644  \u0645\u062a\u0639\u062f \u0628\u062d\u0631\u0641  .";
                    RuleMatch match = new RuleMatch((Rule)this, sentence, tokens[prevTokenIndex].getStartPos(), tokens[prevTokenIndex].getEndPos(), tokens[prevTokenIndex].getStartPos(), token.getEndPos(), msg, "\u062e\u0637\u0623 \u0641\u064a \u0627\u0644\u0641\u0639\u0644 \u0627\u0644\u0645\u062a\u0639\u062f\u064a \u0628\u062d\u0631\u0641");
                    ruleMatches.add(match);
                }
            }
            prevTokenIndex = this.isAttachedTransitiveVerb(token) ? i : 0;
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    private boolean isAttachedTransitiveVerb(AnalyzedTokenReadings mytoken) {
        List verbTokenList = mytoken.getReadings();
        for (AnalyzedToken verbTok : verbTokenList) {
            SuggestionWithMessage verbLemmaMatch;
            String verbLemma = verbTok.getLemma();
            String verbPostag = verbTok.getPOSTag();
            if (verbPostag == null || (verbLemmaMatch = this.wrongWords.get(this.wrongWords.size() - 1).get(verbLemma)) == null) continue;
            return true;
        }
        return false;
    }

    private List<String> getProperPrepositionForTransitiveVerb(AnalyzedTokenReadings mytoken) {
        List verbTokenList = mytoken.getReadings();
        List<String> replacements = new ArrayList<String>();
        for (AnalyzedToken verbTok : verbTokenList) {
            SuggestionWithMessage verbLemmaMatch;
            String verbLemma = verbTok.getLemma();
            String verbPostag = verbTok.getPOSTag();
            if (verbPostag == null || (verbLemmaMatch = this.wrongWords.get(this.wrongWords.size() - 1).get(verbLemma)) == null) continue;
            replacements = Arrays.asList(verbLemmaMatch.getSuggestion().split("\\|"));
            return replacements;
        }
        return replacements;
    }

    private static boolean isRightPreposition(AnalyzedTokenReadings nextToken, List<String> prepositionList) {
        String nextTokenStr = ((AnalyzedToken)nextToken.getReadings().get(0)).getLemma();
        return prepositionList.contains(nextTokenStr);
    }

    private String getCorrectVerbForm(AnalyzedTokenReadings token) {
        return this.generateUnattachedNewForm(token);
    }

    private String getCorrectPrepositionForm(String prepositionLemma, AnalyzedTokenReadings prevtoken) {
        return this.generateAttachedNewForm(prepositionLemma, prevtoken);
    }

    private String generateNewForm(String word, String posTag, char flag) {
        String newposTag = this.tagmanager.setFlag(posTag, "PRONOUN", flag);
        if (flag != '-') {
            newposTag = this.tagmanager.setFlag(newposTag, "OPTION", 'D');
        }
        AnalyzedToken prepAToken = new AnalyzedToken(word, newposTag, word);
        String[] newwordList = ArabicSynthesizer.INSTANCE.synthesize(prepAToken, newposTag);
        String newWord = "";
        if (newwordList.length != 0) {
            newWord = newwordList[0];
        }
        return newWord;
    }

    private String generateUnattachedNewForm(AnalyzedTokenReadings token) {
        String lemma = ((AnalyzedToken)token.getReadings().get(0)).getLemma();
        String postag = ((AnalyzedToken)token.getReadings().get(0)).getPOSTag();
        return this.generateNewForm(lemma, postag, '-');
    }

    private String generateAttachedNewForm(String prepositionLemma, AnalyzedTokenReadings prevtoken) {
        String postag = "PR-;---;---";
        String prevPosTag = ((AnalyzedToken)prevtoken.getReadings().get(0)).getPOSTag();
        char flag = this.tagmanager.getFlag(prevPosTag, "PRONOUN");
        return this.generateNewForm(prepositionLemma, postag, flag);
    }
}

