/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tools;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ArabicUnitsHelper {
    static final Map<String, List<String>> unitsMap2 = new HashMap<String, List<String>>();
    static final Map<String, Map<String, String>> unitsMap = new HashMap<String, Map<String, String>>();
    final short ONE_POS_RAF3 = 0;
    final short ONE_POS_NASB = 1;
    final short ONE_POS_JAR = (short)2;
    final short TWO_POS_RAF3 = (short)3;
    final short TWO_POS_NASB = (short)4;
    final short TWO_POS_JAR = (short)5;
    final short PLURAL_POS_RAF3 = (short)6;
    final short PLURAL_POS_NASB = (short)7;
    final short PLURAL_POS_JAR = (short)8;

    public static boolean isFeminin(String unit) {
        return unitsMap.containsKey(unit) && unitsMap.get(unit).getOrDefault("feminin", "no").equals("yes");
    }

    public static boolean isUnit(String unit) {
        return unitsMap.containsKey(unit);
    }

    public static String getForm(String unit, String category, String inflection) {
        if (inflection.isEmpty()) {
            inflection = "raf3";
        }
        String key = category + "_" + inflection;
        if (unitsMap.containsKey(unit)) {
            return unitsMap.get(unit).getOrDefault(key, "[" + unit + "]");
        }
        return "[[" + unit + "]]";
    }

    public static String getOneForm(String unit, String inflection) {
        return ArabicUnitsHelper.getForm(unit, "one", inflection);
    }

    public static String getTwoForm(String unit, String inflection) {
        return ArabicUnitsHelper.getForm(unit, "two", inflection);
    }

    public static String getPluralForm(String unit, String inflection) {
        return ArabicUnitsHelper.getForm(unit, "plural", inflection);
    }

    static {
        HashMap<String, String> unitsEntry = new HashMap<String, String>();
        unitsEntry.put("feminin", "no");
        unitsEntry.put("one_raf3", "\u062f\u064a\u0646\u0627\u0631");
        unitsEntry.put("one_nasb", "\u062f\u064a\u0646\u0627\u0631\u064b\u0627");
        unitsEntry.put("one_jar", "\u062f\u064a\u0646\u0627\u0631\u064d");
        unitsEntry.put("two_raf3", "\u062f\u064a\u0646\u0627\u0631\u0627\u0646");
        unitsEntry.put("two_nasb", "\u062f\u064a\u0646\u0627\u0631\u064a\u0646");
        unitsEntry.put("two_jar", "\u062f\u064a\u0646\u0627\u0631\u064a\u0646");
        unitsEntry.put("plural_raf3", "\u062f\u0646\u0627\u0646\u064a\u0631\u064f");
        unitsEntry.put("plural_nasb", "\u062f\u0646\u0627\u0646\u064a\u0631\u064e");
        unitsEntry.put("plural_jar", "\u062f\u0646\u0627\u0646\u064a\u0631\u064e");
        unitsMap.put("\u062f\u064a\u0646\u0627\u0631", unitsEntry);
        unitsEntry = new HashMap();
        unitsEntry.put("feminin", "no");
        unitsEntry.put("one_raf3", "\u062f\u0631\u0647\u0645");
        unitsEntry.put("one_nasb", "\u062f\u0631\u0647\u0645\u064b\u0627");
        unitsEntry.put("one_jar", "\u062f\u0631\u0647\u0645\u064d");
        unitsEntry.put("two_raf3", "\u062f\u0631\u0647\u0645\u0627\u0646");
        unitsEntry.put("two_nasb", "\u062f\u0631\u0647\u0645\u064a\u0646");
        unitsEntry.put("two_jar", "\u062f\u0631\u0647\u0645\u064a\u0646");
        unitsEntry.put("plural_raf3", "\u062f\u0631\u0627\u0647\u0645\u064f");
        unitsEntry.put("plural_nasb", "\u062f\u0631\u0627\u0647\u0645\u064e");
        unitsEntry.put("plural_jar", "\u062f\u0631\u0627\u0647\u0645\u064e");
        unitsMap.put("\u062f\u0631\u0647\u0645", unitsEntry);
        unitsEntry = new HashMap();
        unitsEntry.put("feminin", "no");
        unitsEntry.put("one_raf3", "\u062f\u0648\u0644\u0627\u0631");
        unitsEntry.put("one_nasb", "\u062f\u0648\u0644\u0627\u0631\u064b\u0627");
        unitsEntry.put("one_jar", "\u062f\u0648\u0644\u0627\u0631\u064d");
        unitsEntry.put("two_raf3", "\u062f\u0648\u0644\u0627\u0631\u0627\u0646");
        unitsEntry.put("two_nasb", "\u062f\u0648\u0644\u0627\u0631\u064a\u0646");
        unitsEntry.put("two_jar", "\u062f\u0648\u0644\u0627\u0631\u064a\u0646");
        unitsEntry.put("plural_raf3", "\u062f\u0648\u0644\u0627\u0631\u0627\u062a\u064c");
        unitsEntry.put("plural_nasb", "\u062f\u0648\u0644\u0627\u0631\u0627\u062a\u064d");
        unitsEntry.put("plural_jar", "\u062f\u0648\u0644\u0627\u0631\u0627\u062a\u064d");
        unitsMap.put("\u062f\u0648\u0644\u0627\u0631", unitsEntry);
        unitsEntry = new HashMap();
        unitsEntry.put("feminin", "yes");
        unitsEntry.put("one_raf3", "\u0644\u064a\u0631\u0629");
        unitsEntry.put("one_nasb", "\u0644\u064a\u0631\u0629\u064b");
        unitsEntry.put("one_jar", "\u0644\u064a\u0631\u0629\u064d");
        unitsEntry.put("two_raf3", "\u0644\u064a\u0631\u062a\u0627\u0646");
        unitsEntry.put("two_nasb", "\u0644\u064a\u0631\u062a\u064a\u0646");
        unitsEntry.put("two_jar", "\u0644\u064a\u0631\u062a\u064a\u0646");
        unitsEntry.put("plural_raf3", "\u0644\u064a\u0631\u0627\u062a\u064c");
        unitsEntry.put("plural_nasb", "\u0644\u064a\u0631\u0627\u062a\u064d");
        unitsEntry.put("plural_jar", "\u0644\u064a\u0631\u0627\u062a\u064d");
        unitsMap.put("\u0644\u064a\u0631\u0629", unitsEntry);
    }
}

